/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.bungee;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import net.shortninja.staffplus.libs.com.google.gson.Gson;
import net.shortninja.staffplus.libs.com.google.gson.TypeAdapter;
import net.shortninja.staffplus.libs.com.google.gson.TypeAdapterFactory;
import net.shortninja.staffplus.libs.com.google.gson.reflect.TypeToken;
import net.shortninja.staffplus.libs.com.google.gson.stream.JsonReader;
import net.shortninja.staffplus.libs.com.google.gson.stream.JsonToken;
import net.shortninja.staffplus.libs.com.google.gson.stream.JsonWriter;

public class OptionalTypeAdapter<E>
extends TypeAdapter<Optional<E>> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class<T> rawType = type.getRawType();
            if (rawType != Optional.class) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type.getType();
            Type actualType = parameterizedType.getActualTypeArguments()[0];
            TypeAdapter<?> adapter = gson.getAdapter(TypeToken.get(actualType));
            return new OptionalTypeAdapter(adapter);
        }
    };
    private final TypeAdapter<E> adapter;

    public OptionalTypeAdapter(TypeAdapter<E> adapter) {
        this.adapter = adapter;
    }

    @Override
    public void write(JsonWriter out, Optional<E> value) throws IOException {
        if (value.isPresent()) {
            this.adapter.write(out, value.get());
        } else {
            out.nullValue();
        }
    }

    @Override
    public Optional<E> read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek != JsonToken.NULL) {
            return Optional.ofNullable(this.adapter.read(in));
        }
        in.nextNull();
        return Optional.empty();
    }
}

