/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common.bungee;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.common.bungee.BungeeAction;
import net.shortninja.staffplus.core.common.bungee.BungeeContext;
import net.shortninja.staffplus.core.common.bungee.BungeeMessage;
import net.shortninja.staffplus.core.common.bungee.GsonParser;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@IocBean
public class BungeeClient {
    private final GsonParser gsonParser;
    private final StaffPlusPlus staffPlusPlus;

    public BungeeClient(GsonParser gsonParser, @InjectTubingPlugin StaffPlusPlus staffPlusPlus) {
        this.gsonParser = gsonParser;
        this.staffPlusPlus = staffPlusPlus;
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)staffPlusPlus, "BungeeCord");
    }

    public void sendAll(CommandSender sender, BungeeAction action, BungeeContext context, String message) {
        this.send(sender, action, "ALL", context, message);
    }

    public void send(CommandSender sender, BungeeAction action, String server, BungeeContext context, String message) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        } else {
            Collection onlinePlayers = Bukkit.getOnlinePlayers();
            if (onlinePlayers.iterator().hasNext()) {
                player = (Player)onlinePlayers.iterator().next();
            }
        }
        if (player != null) {
            try {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF(action.getActionString());
                out.writeUTF(server);
                out.writeUTF(context.getContextString());
                ByteArrayOutputStream msgbytes = new ByteArrayOutputStream();
                DataOutputStream msgout = new DataOutputStream(msgbytes);
                msgout.writeUTF(message);
                out.writeShort(msgbytes.toByteArray().length);
                out.write(msgbytes.toByteArray());
                player.sendPluginMessage((Plugin)this.staffPlusPlus, "BungeeCord", out.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendMessage(Player player, String channel, Object event, List<String> servers) {
        servers.forEach(server -> this.sendToServer(player, channel, event, (String)server));
    }

    public void sendMessage(Player player, String channel, Object event, ServerSyncConfig serverSyncConfig) {
        if (serverSyncConfig.isMatchesAll()) {
            this.sendMessage(player, channel, event);
        } else {
            serverSyncConfig.getServers().forEach(server -> this.sendToServer(player, channel, event, (String)server));
        }
    }

    public void sendMessage(Player player, String channel, Object event) {
        this.sendToServer(player, channel, event, "ALL");
    }

    private void sendToServer(Player player, String channel, Object event, String server) {
        if (player == null) {
            return;
        }
        try {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Forward");
            out.writeUTF(server);
            out.writeUTF(channel);
            ByteArrayOutputStream msgbytes = new ByteArrayOutputStream();
            DataOutputStream msgout = new DataOutputStream(msgbytes);
            msgout.writeUTF(this.gsonParser.toJson(event));
            out.writeShort(msgbytes.toByteArray().length);
            out.write(msgbytes.toByteArray());
            player.sendPluginMessage((Plugin)this.staffPlusPlus, "BungeeCord", out.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <T> Optional<T> handleReceived(String channel, String subChannel, byte[] message, Class<? extends BungeeMessage> classOf) {
        if (!channel.equals("BungeeCord")) {
            return Optional.empty();
        }
        try {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            String subchannel = in.readUTF();
            if (subchannel.equals(subChannel)) {
                short len = in.readShort();
                byte[] msgbytes = new byte[len];
                in.readFully(msgbytes);
                DataInputStream msgin = new DataInputStream(new ByteArrayInputStream(msgbytes));
                String data = msgin.readUTF();
                BungeeMessage bungeeMessage = this.gsonParser.fromJson(data, classOf);
                if (this.getDuration(bungeeMessage) > 10L) {
                    return Optional.empty();
                }
                return Optional.of(bungeeMessage);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    private long getDuration(BungeeMessage bungeeMessage) {
        long now = System.currentTimeMillis();
        return (now - bungeeMessage.getTimestamp()) / 1000L;
    }
}

