/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddress;
import net.shortninja.staffplus.libs.inet.ipaddr.IPAddressString;
import net.shortninja.staffplus.libs.org.apache.commons.lang.WordUtils;
import net.shortninja.staffplus.libs.org.apache.commons.net.util.SubnetUtils;
import net.shortninja.staffplus.libs.org.apache.commons.validator.routines.InetAddressValidator;
import net.shortninja.staffplusplus.ILocation;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class JavaUtils {
    private static final List<TimeUnit> timeUnits = Arrays.asList(TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS);
    private static final String DEFAULT_MESSAGE_COLOR = "&6";
    private static final String DEFAULT_CLICK_MESSAGE_COLOR = "&9";

    public static String toHumanReadableDuration(long millis) {
        if (millis <= 0L) {
            return "None";
        }
        StringBuilder builder = new StringBuilder();
        long acc = millis;
        int count = 0;
        for (TimeUnit timeUnit : timeUnits) {
            long convert = timeUnit.convert(acc, TimeUnit.MILLISECONDS);
            if (convert > 0L) {
                builder.append(convert).append(' ').append(WordUtils.capitalizeFully(timeUnit.name())).append(", ");
                acc -= TimeUnit.MILLISECONDS.convert(convert, timeUnit);
                ++count;
            }
            if (count < 2) continue;
            break;
        }
        if (builder.length() == 0) {
            return "None";
        }
        return builder.substring(0, builder.length() - 2);
    }

    public static boolean isValidEnum(Class enumClass, String enumName) {
        if (enumClass == null || enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(enumClass, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static long getDuration(long timestamp) {
        if (timestamp <= System.currentTimeMillis()) {
            return 0L;
        }
        return Math.abs(System.currentTimeMillis() - timestamp);
    }

    public static boolean isInteger(String string) {
        boolean isInteger = true;
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException exception) {
            isInteger = false;
        }
        return isInteger;
    }

    public static List<String> stringToList(String commas) {
        if (commas == null) {
            throw new IllegalArgumentException("Commas may not be null.");
        }
        return new ArrayList<String>(Arrays.asList(commas.split("\\s*,\\s*")));
    }

    public static String compileWords(String[] args, int index) {
        StringBuilder builder = new StringBuilder();
        for (int i = index; i < args.length; ++i) {
            builder.append(args[i]).append(" ");
        }
        return builder.toString().trim();
    }

    public static int getItemSlot(PlayerInventory inventory, ItemStack item) {
        int slot = 0;
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack current = contents[i];
            if (current == null || !current.equals((Object)item)) continue;
            slot = i;
            break;
        }
        return slot;
    }

    public static void clearInventory(Player player) {
        player.getInventory().clear();
        player.getInventory().setHelmet(null);
        player.getInventory().setChestplate(null);
        player.getInventory().setLeggings(null);
        player.getInventory().setBoots(null);
    }

    public static String serializeLocation(Location location) {
        return location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
    }

    public static String serializeLocation(ILocation location) {
        return location.getX() + ", " + location.getY() + ", " + location.getZ();
    }

    public static String formatTypeName(String type) {
        return type.replace("_", " ").toLowerCase();
    }

    public static List<Player> getOnlinePlayers() {
        return new ArrayList<Player>(Bukkit.getOnlinePlayers());
    }

    public static Player getTargetPlayer(Player player) {
        Location location = player.getLocation();
        Player targetPlayer = null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            Vector targetVector;
            if (player.getWorld() != p.getWorld() || location.distanceSquared(p.getLocation()) > 36.0 || player.getName().equals(p.getName()) || Math.round((targetVector = p.getLocation().toVector().subtract(location.toVector()).normalize()).dot(location.getDirection())) != 1L) continue;
            targetPlayer = p;
            break;
        }
        return targetPlayer;
    }

    public static boolean hasInventorySpace(Player player) {
        return player.getInventory().firstEmpty() != -1;
    }

    public static int parseMcVer(String ver) {
        return Integer.parseInt(ver.split("\\.")[1].replaceAll("[^0-9]", ""));
    }

    public static Vector makeVelocitySafe(Vector velocity) {
        while (velocity.getX() > 4.0) {
            velocity.setX(velocity.getX() - 0.5);
        }
        while (velocity.getY() > 4.0) {
            velocity.setY(velocity.getY() - 0.5);
        }
        while (velocity.getZ() > 4.0) {
            velocity.setZ(velocity.getZ() - 0.5);
        }
        while (velocity.getX() < -4.0) {
            velocity.setX(velocity.getX() + 0.5);
        }
        while (velocity.getY() < -4.0) {
            velocity.setY(velocity.getY() + 0.5);
        }
        while (velocity.getZ() < -4.0) {
            velocity.setZ(velocity.getZ() + 0.5);
        }
        return velocity;
    }

    public static List<String> formatLines(String target, int maxLength) {
        if (target == null) {
            return Collections.emptyList();
        }
        if (target.length() <= maxLength) {
            return Collections.singletonList(target);
        }
        BreakIterator boundary = BreakIterator.getLineInstance(Locale.getDefault());
        boundary.setText(target);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = 0;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        while (end != -1) {
            String word = target.substring(start, end);
            if ((lineLength += word.length()) >= maxLength) {
                lines.add(line.toString());
                line = new StringBuilder();
                lineLength = word.length();
            }
            line.append(word);
            start = end;
            end = boundary.next();
        }
        if (!line.toString().isEmpty()) {
            lines.add(line.toString());
        }
        return lines;
    }

    public static <T> List<T> getPageOfList(List<T> sourceList, int page, int pageSize) {
        if (pageSize < 0 || page < 0) {
            throw new IllegalArgumentException("invalid page size: " + pageSize);
        }
        int fromIndex = page * pageSize;
        if (sourceList == null || sourceList.size() <= fromIndex) {
            return Collections.emptyList();
        }
        return sourceList.subList(fromIndex, Math.min(fromIndex + pageSize, sourceList.size()));
    }

    public static JSONMessage buildClickableMessage(String message, String clickMessage, String tooltip, String command, boolean showButton) {
        if (!message.startsWith(DEFAULT_MESSAGE_COLOR)) {
            message = DEFAULT_MESSAGE_COLOR + message;
        }
        if (!clickMessage.startsWith(DEFAULT_CLICK_MESSAGE_COLOR)) {
            clickMessage = DEFAULT_CLICK_MESSAGE_COLOR + clickMessage;
        }
        JSONMessage jsonMessage = JSONMessage.create();
        JavaUtils.addColor(message, jsonMessage::then);
        if (showButton) {
            jsonMessage.then(" ");
            JavaUtils.addColor(clickMessage, jsonMessage::then);
            jsonMessage.tooltip(tooltip).runCommand("/" + command);
        }
        return jsonMessage;
    }

    public static JSONMessage buildChoiceMessage(String message, String option1Message, String option1Command, String option2Message, String option2Command) {
        JSONMessage jsonMessage = JSONMessage.create();
        JavaUtils.addColor(message, jsonMessage::then);
        JavaUtils.addColor(" " + option1Message, jsonMessage::then);
        jsonMessage.runCommand("/" + option1Command);
        JavaUtils.addColor(" &7| ", jsonMessage::then);
        JavaUtils.addColor(option2Message, jsonMessage::then);
        jsonMessage.runCommand("/" + option2Command);
        return jsonMessage;
    }

    private static void addColor(String message, Function<String, JSONMessage> jsonMessageFunction) {
        String[] coloredString;
        for (String messagePart : coloredString = message.split("(?=&1|&2|&3|&4|&5|&6|&7|&8|&9|&0|&a|&e|&b|&d|&f|&c|&k|&l|&m|&n|&o|&r)")) {
            if (messagePart.length() < 2) {
                jsonMessageFunction.apply(messagePart).color(ChatColor.GOLD);
                continue;
            }
            boolean containsColor = Arrays.stream(ChatColor.values()).anyMatch(chatColor -> messagePart.startsWith("&" + chatColor.getChar()));
            if (containsColor) {
                ChatColor color = ChatColor.getByChar((String)messagePart.substring(1, 2));
                jsonMessageFunction.apply(messagePart.substring(2)).color(color);
                continue;
            }
            jsonMessageFunction.apply(messagePart).color(ChatColor.GOLD);
        }
    }

    public static long convertIp(String ipAddress) {
        IPAddress addr = new IPAddressString(ipAddress).getAddress();
        return addr.getValue().longValue();
    }

    public static String[] cidrToIpRange(String cidr) {
        IPAddressString string = new IPAddressString(cidr);
        IPAddress addr = string.getAddress();
        IPAddress lower = addr.getLower();
        IPAddress upper = addr.getUpper();
        return new String[]{lower.toString(), upper.toString()};
    }

    public static boolean isValidCidrOrIp(String cidrIp) {
        boolean isValid = true;
        try {
            new SubnetUtils(cidrIp);
        }
        catch (IllegalArgumentException e) {
            isValid = false;
        }
        return InetAddressValidator.getInstance().isValid(cidrIp) || isValid;
    }

    public static String replacePlaceholders(String message, Map<String, String> placeholders) {
        String result = message;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

