/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.utils.Strings;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public final class Items {
    private Items() {
    }

    public static ItemStackBuilder builder() {
        return new ItemStackBuilder();
    }

    public static ItemStack createColoredArmor(Armor armor, Color color, String name) {
        ItemStack leatherArmor = new ItemStack(armor.getMaterial());
        LeatherArmorMeta meta = (LeatherArmorMeta)leatherArmor.getItemMeta();
        meta.setColor(color);
        if (name != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        leatherArmor.setItemMeta((ItemMeta)meta);
        return leatherArmor;
    }

    public static ItemStack createGreenColoredGlass(String name, String lore) {
        return Items.builder().setMaterial(Material.GREEN_STAINED_GLASS_PANE).setName(name).addLore(lore).build();
    }

    public static ItemStack createRedColoredGlass(String name, String lore) {
        return Items.builder().setMaterial(Material.RED_STAINED_GLASS_PANE).setName(name).addLore(lore).build();
    }

    public static ItemStack createWhiteColoredGlass(String name, String lore) {
        return Items.builder().setMaterial(Material.WHITE_STAINED_GLASS_PANE).setName(name).addLore(lore).build();
    }

    public static ItemStack createOrangeColoredGlass(String name, String lore) {
        return Items.builder().setMaterial(Material.ORANGE_STAINED_GLASS_PANE).setName(name).addLore(lore).build();
    }

    public static ItemStack createDoor(String name, String lore) {
        return Items.builder().setMaterial(Material.SPRUCE_DOOR).setName(name).addLore(lore).build();
    }

    public static ItemStack createBackDoor() {
        return Items.editor(Items.createDoor("Back", "Go back")).setAmount(1).build();
    }

    public static ItemStack createSkull(String name) {
        ItemStack skull = new ItemStack(Material.valueOf((String)"PLAYER_HEAD"), 1);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        skullMeta.setOwner(name);
        return skull;
    }

    public static ItemStackBuilder editor(ItemStack itemStack) {
        return new ItemStackBuilder(itemStack);
    }

    public static ItemStack createBook(String name, String lore) {
        ArrayList<String> loreList = new ArrayList<String>(JavaUtils.formatLines(lore, 30));
        return Items.builder().setName(name).setLore(loreList).setMaterial(Material.BOOK).build();
    }

    public static ItemStack createAnvil(String name, String lore) {
        ArrayList<String> loreList = new ArrayList<String>(JavaUtils.formatLines(lore, 30));
        return Items.builder().setName(name).setLore(loreList).setMaterial(Material.ANVIL).build();
    }

    public static ItemStack createPaper(String name, String lore) {
        ArrayList<String> loreList = new ArrayList<String>(JavaUtils.formatLines(lore, 30));
        return Items.builder().setName(name).setLore(loreList).setMaterial(Material.PAPER).build();
    }

    public static class ItemStackBuilder {
        private final ItemStack itemStack;

        ItemStackBuilder() {
            this.itemStack = new ItemStack(Material.QUARTZ);
            this.setName("");
            this.setLore(new ArrayList<String>());
        }

        public ItemStackBuilder(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public ItemStackBuilder setMaterial(Material material) {
            this.itemStack.setType(material);
            return this;
        }

        public ItemStackBuilder changeAmount(int change) {
            this.itemStack.setAmount(this.itemStack.getAmount() + change);
            return this;
        }

        public ItemStackBuilder setAmount(int amount) {
            this.itemStack.setAmount(amount);
            return this;
        }

        public ItemStackBuilder setData(short data) {
            this.itemStack.setDurability(data);
            return this;
        }

        public ItemStackBuilder setData(MaterialData data) {
            this.itemStack.setData(data);
            return this;
        }

        public ItemStackBuilder setEnchantments(HashMap<Enchantment, Integer> enchantments) {
            for (Enchantment enchantment : this.itemStack.getEnchantments().keySet()) {
                this.itemStack.removeEnchantment(enchantment);
            }
            this.itemStack.addUnsafeEnchantments(enchantments);
            return this;
        }

        public ItemStackBuilder addEnchantment(Enchantment enchantment, int level) {
            this.itemStack.addUnsafeEnchantment(enchantment, level);
            return this;
        }

        public ItemStackBuilder setName(String name) {
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setDisplayName(name.equals("") ? " " : Strings.format(name));
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemStackBuilder addBlankLore() {
            this.addLore(" ");
            return this;
        }

        public ItemStackBuilder addLineLore() {
            return this.addLineLore(20);
        }

        public ItemStackBuilder addLineLore(int length) {
            this.addLore("&8&m&l" + Strings.repeat('-', length));
            return this;
        }

        public ItemStackBuilder addLore(String ... lore) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            String[] newLore = new String[lore.length];
            for (String string : lore) {
                coloredLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
            }
            lore = coloredLore.toArray(newLore);
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            ArrayList original = itemMeta.getLore();
            if (original == null) {
                original = new ArrayList();
            }
            Collections.addAll(original, Strings.format(lore));
            itemMeta.setLore(original);
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemStackBuilder addLore(List<String> lore) {
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            ArrayList<String> original = itemMeta.getLore();
            if (original == null) {
                original = new ArrayList<String>();
            }
            original.addAll(Strings.format(lore));
            itemMeta.setLore(original);
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemStackBuilder setLore(String ... lore) {
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setLore(Strings.format(Arrays.asList(lore)));
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemStackBuilder setLore(List<String> lore) {
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setLore(Strings.format(lore));
            this.itemStack.setItemMeta(itemMeta);
            return this;
        }

        public ItemStack build() {
            return this.itemStack;
        }
    }

    public static enum Armor {
        HELMET(Material.LEATHER_HELMET),
        CHESTPLATE(Material.LEATHER_CHESTPLATE),
        LEGGINGS(Material.LEATHER_LEGGINGS),
        BOOTS(Material.LEATHER_BOOTS);

        private Material material;

        private Armor(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }
    }

    public static class BookBuilder {
        private final ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK);
        private BookMeta meta = (BookMeta)this.itemStack.clone().getItemMeta();

        BookBuilder() {
            this.meta.setTitle(Strings.format("&lWritten Book"));
            this.meta.setAuthor("Hex Framework");
        }

        public BookBuilder setTitle(String title) {
            this.meta.setTitle(Strings.format(title));
            return this;
        }

        public BookBuilder setAuthor(String author) {
            this.meta.setAuthor(Strings.format(author));
            return this;
        }

        public BookBuilder addPage(String ... lines) {
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                builder.append(Strings.format(line == null || line.isEmpty() ? " " : line)).append("\n");
            }
            this.meta.addPage(new String[]{builder.toString()});
            return this;
        }

        public ItemStack build() {
            ItemStack itemStack = this.itemStack.clone();
            itemStack.setItemMeta((ItemMeta)this.meta);
            return itemStack;
        }
    }
}

