/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers;

import java.sql.Connection;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.DatabaseType;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.SqlConnectionProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.MysqlQueryBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.QueryBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.SqliteQueryBuilder;

public class QueryBuilderFactory {
    private final DatabaseType databaseType;
    private final SqlConnectionProvider sqlConnectionProvider;

    public QueryBuilderFactory(DatabaseType databaseType, SqlConnectionProvider sqlConnectionProvider) {
        this.databaseType = databaseType;
        this.sqlConnectionProvider = sqlConnectionProvider;
    }

    public QueryBuilder create() {
        if (this.databaseType == DatabaseType.MYSQL) {
            return new MysqlQueryBuilder(this.sqlConnectionProvider);
        }
        return new SqliteQueryBuilder(this.sqlConnectionProvider);
    }

    public QueryBuilder create(Connection connection) {
        if (this.databaseType == DatabaseType.MYSQL) {
            return new MysqlQueryBuilder(connection);
        }
        return new SqliteQueryBuilder(connection);
    }
}

