/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.DatabaseType;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.Migration;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.MigrationsProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.SqlConnectionProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.SqlMigrationException;
import net.shortninja.staffplus.libs.org.slf4j.Logger;
import net.shortninja.staffplus.libs.org.slf4j.LoggerFactory;

public class Migrations {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrations.class);
    private final List<? extends Migration> migrationsScripts;
    private final SqlConnectionProvider sqlConnectionProvider;

    public Migrations(SqlConnectionProvider sqlConnectionProvider, MigrationsProvider migrationsProvider) {
        this.migrationsScripts = migrationsProvider.getMigrations();
        this.sqlConnectionProvider = sqlConnectionProvider;
    }

    public void run(String migrationsTableName) {
        if (this.sqlConnectionProvider.getDatabaseType() == DatabaseType.MYSQL) {
            this.createMigrationTableMysql(migrationsTableName);
        } else {
            this.createMigrationTableSqlite(migrationsTableName);
        }
        this.runMigrations(migrationsTableName);
    }

    private void createMigrationTableSqlite(String migrationsTableName) {
        try (Connection connect = this.sqlConnectionProvider.getConnection();
             Statement stmt = connect.createStatement();){
            LOGGER.info("Creating migration table");
            String sql = "CREATE TABLE IF NOT EXISTS " + migrationsTableName + " (\n\tid integer PRIMARY KEY,\n\tversion integer NOT NULL\n);";
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new SqlMigrationException("Failure creating migration table: {}", e);
        }
    }

    private void createMigrationTableMysql(String migrationsTableName) {
        try (Connection connect = this.sqlConnectionProvider.getConnection();
             Statement stmt = connect.createStatement();){
            LOGGER.info("Creating migration table");
            String sql = "CREATE TABLE IF NOT EXISTS " + migrationsTableName + " (\n\tid BIGINT PRIMARY KEY AUTO_INCREMENT,\n\tversion integer NOT NULL\n);";
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new SqlMigrationException("Failure creating migration table: {}", e);
        }
    }

    private void runMigrations(String migrationsTableName) {
        try (Connection connect = this.sqlConnectionProvider.getConnection();){
            LOGGER.info("Starting migrations");
            connect.setAutoCommit(false);
            int maxVersion = this.getMaxVersion(migrationsTableName, connect);
            List validMigrations = this.migrationsScripts.stream().filter(m -> m.getVersion() > maxVersion).sorted(Comparator.comparingInt(Migration::getVersion)).collect(Collectors.toList());
            for (Migration migration : validMigrations) {
                try {
                    if (migration.getStatement(connect) != null) {
                        this.executeStatement(connect, migration.getStatement(connect));
                    }
                    if (migration.getStatements(connect) != null) {
                        for (String s : migration.getStatements(connect)) {
                            this.executeStatement(connect, s);
                        }
                    }
                    try (PreparedStatement migrationStatement = connect.prepareStatement("INSERT INTO " + migrationsTableName + " (version) VALUES (?);");){
                        migrationStatement.setInt(1, migration.getVersion());
                        migrationStatement.execute();
                    }
                    connect.commit();
                }
                catch (SQLException e) {
                    connect.rollback();
                    connect.setAutoCommit(true);
                    throw new SqlMigrationException("Failure executing migrations: {}", e);
                }
            }
            connect.commit();
            connect.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new SqlMigrationException("Failure connecting to the database: {}", e);
        }
    }

    private void executeStatement(Connection connect, String statement) throws SQLException {
        try (Statement stmt = connect.createStatement();){
            stmt.execute(statement);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMaxVersion(String migrationsTableName, Connection connect) {
        try (Statement stmt = connect.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT max(version) as max from " + migrationsTableName);
            int max = resultSet.next() ? resultSet.getInt("max") : 0;
            LOGGER.info("Latest migration version = {}", (Object)max);
            int n = max;
            return n;
        }
        catch (SQLException e) {
            throw new SqlMigrationException("Failure retrieving max migration version: {}", e);
        }
    }
}

