/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocContainer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationFile;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.YamlConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.Jsoup;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Document;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Element;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.select.Elements;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.TubingPermissionService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.actionquery.ActionQueryParser;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.TubingGuiException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.history.GuiHistoryStack;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.InventoryMapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.style.TubingGuiStyleIdViewProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.ChatTemplateResolver;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.FreemarkerGuiTemplateResolver;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplateProcessor;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.TemplateConfigResolver;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.TubingXmlConfigParser;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.TubingXmlToTubingGuiMapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.TubingGuiStyleParser;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.test.TubingBukkitUtilStub;
import net.shortninja.staffplus.libs.org.apache.commons.io.IOUtils;
import net.shortninja.staffplus.libs.org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public abstract class TubingGuiTemplateTest {
    protected static final UUID PLAYER_UUID = UUID.fromString("3723136f-40dd-4f27-8505-8fa880f14e95");
    protected GuiActionService guiActionService;
    @Mock
    protected Player player;
    @Mock
    protected ConfigurationLoader configurationLoader;
    @Mock
    protected ChatTemplateResolver chatTemplateResolver;
    @Mock
    protected TubingXmlToTubingGuiMapper tubingGuiXmlParser;
    @Mock
    protected TubingGuiStyleParser tubingGuiStyleParser;
    @Mock
    protected InventoryMapper inventoryMapper;
    @Mock
    protected TubingGuiStyleIdViewProvider tubingGuiStyleIdViewProvider;
    @Mock
    protected IocContainer iocContainer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected TubingPlugin tubingPlugin;
    protected TemplateConfigResolver templateConfigResolverSpy;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TubingGui tubingGui;
    @Captor
    private ArgumentCaptor<String> xmlCaptor;

    @BeforeEach
    public void setUp() {
        TubingPlugin pluginMock = (TubingPlugin)Mockito.mock(this.getPluginClass());
        Mockito.when((Object)pluginMock.getName()).thenReturn((Object)"staffplus");
        Mockito.when((Object)pluginMock.getIocContainer()).thenReturn((Object)this.iocContainer);
        Map<String, FileConfiguration> collect = this.getConfigurationFiles().stream().collect(Collectors.toMap(ConfigurationFile::getIdentifier, c -> this.loadConfig(c.getPath()), (a2, b) -> a2));
        Mockito.when(this.configurationLoader.getConfigurationFiles()).thenReturn(collect);
        Object guiController = this.getGuiController();
        ((IocContainer)Mockito.doReturn((Object)guiController).when((Object)this.iocContainer)).get(guiController.getClass());
        Mockito.when((Object)this.tubingGuiXmlParser.toTubingGui((Player)ArgumentMatchers.eq((Object)this.player), (String)ArgumentMatchers.any())).thenReturn((Object)this.tubingGui);
        Mockito.when((Object)this.player.getUniqueId()).thenReturn((Object)PLAYER_UUID);
        TemplateConfigResolver templateConfigResolver = new TemplateConfigResolver(this.configurationLoader);
        this.templateConfigResolverSpy = (TemplateConfigResolver)Mockito.spy((Object)templateConfigResolver);
        FreemarkerGuiTemplateResolver guiTemplateResolver = new FreemarkerGuiTemplateResolver(pluginMock, this.templateConfigResolverSpy, this.getTubingPermissionService());
        GuiTemplateProcessor guiTemplateProcessor = new GuiTemplateProcessor(guiTemplateResolver, new TubingXmlConfigParser(this.templateConfigResolverSpy), this.tubingGuiXmlParser, this.tubingGuiStyleParser);
        this.guiActionService = new GuiActionService(pluginMock, this.configurationLoader, guiTemplateProcessor, this.chatTemplateResolver, new ActionQueryParser(), new TubingBukkitUtilStub(), this.inventoryMapper, this.tubingGuiStyleIdViewProvider, new GuiHistoryStack(), Collections.emptyList());
        this.guiActionService.loadGuiController(guiController.getClass());
    }

    public void validateSnapshot(Player player, String actionQuery, String snapshotFile) throws URISyntaxException, IOException {
        this.guiActionService.executeAction(player, actionQuery);
        ((TubingXmlToTubingGuiMapper)Mockito.verify((Object)this.tubingGuiXmlParser)).toTubingGui((Player)ArgumentMatchers.eq((Object)player), (String)this.xmlCaptor.capture());
        this.validateMaterials((String)this.xmlCaptor.getValue());
        this.validateXml((String)this.xmlCaptor.getValue(), snapshotFile);
    }

    public abstract Object getGuiController();

    public abstract Class<? extends TubingPlugin> getPluginClass();

    public abstract List<ConfigurationFile> getConfigurationFiles();

    public abstract TubingPermissionService getTubingPermissionService();

    public void validateMaterials(String guiXml) {
        Document document = Jsoup.parse(guiXml);
        Elements materialElements = document.getElementsByAttribute("material");
        for (Element materialElement : materialElements) {
            String materialString = materialElement.attr("material");
            Material.valueOf((String)materialString);
        }
    }

    public void validateXml(String actualXml, String pathToXml) throws URISyntaxException, IOException {
        URL url = TubingGuiTemplateTest.class.getResource(pathToXml);
        Path resPath = Paths.get(url.toURI());
        String templateXml = new String(Files.readAllBytes(resPath), "UTF8");
        Assertions.assertEquals((Object)TubingGuiTemplateTest.trim(templateXml), (Object)TubingGuiTemplateTest.trim(actualXml));
    }

    public FileConfiguration loadConfig(String path) {
        InputStream resource = this.getPluginClass().getResourceAsStream("/" + path);
        Validate.notNull(resource, "File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(IOUtils.toString(resource));
        }
        catch (Exception e) {
            throw new TubingGuiException("Cannot load " + path, e);
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String trim(String input) {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line.trim());
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

