/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiItem;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.style.StyleConfig;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.StyleRepository;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.TubingGuiItemStyleParser;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.TubingGuiTextStyleParser;

@IocBean
public class TubingGuiStyleParser {
    private final StyleRepository styleRepository;
    private final TubingGuiItemStyleParser tubingGuiItemStyleParser;
    private final TubingGuiTextStyleParser tubingGuiTextStyleParser;

    public TubingGuiStyleParser(StyleRepository styleRepository, TubingGuiItemStyleParser tubingGuiItemStyleParser, TubingGuiTextStyleParser tubingGuiTextStyleParser) {
        this.styleRepository = styleRepository;
        this.tubingGuiItemStyleParser = tubingGuiItemStyleParser;
        this.tubingGuiTextStyleParser = tubingGuiTextStyleParser;
    }

    public void parse(TubingGui tubingGui) {
        if (tubingGui.getId().isPresent()) {
            Optional<StyleConfig> style = this.styleRepository.getStyleConfigById(tubingGui.getId().get());
            style.flatMap(StyleConfig::getSize).ifPresent(tubingGui::setSize);
        }
        this.tubingGuiTextStyleParser.parse(tubingGui.getTitle());
        for (TubingGuiItem value : tubingGui.getGuiItems().values()) {
            this.tubingGuiItemStyleParser.parse(value);
        }
    }
}

