/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiItem;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiText;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.style.StyleConfig;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.StyleRepository;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.TubingGuiTextStyleParser;

@IocBean
public class TubingGuiItemStyleParser {
    private final StyleRepository styleRepository;
    private final TubingGuiTextStyleParser tubingGuiTextStyleParser;

    public TubingGuiItemStyleParser(StyleRepository styleRepository, TubingGuiTextStyleParser tubingGuiTextStyleParser) {
        this.styleRepository = styleRepository;
        this.tubingGuiTextStyleParser = tubingGuiTextStyleParser;
    }

    public void parse(TubingGuiItem tubingGuiItem) {
        if (!tubingGuiItem.getStyleId().isPresent()) {
            return;
        }
        Optional<StyleConfig> style = this.styleRepository.getStyleConfigById(tubingGuiItem.getStyleId().get());
        if (style.isPresent()) {
            if (style.get().isHidden().isPresent()) {
                tubingGuiItem.setHidden(style.get().isHidden().get());
            }
            if (style.get().isEnchanted().isPresent()) {
                tubingGuiItem.getTubingGuiItemStack().setEnchanted(style.get().isEnchanted().get());
            }
            if (style.get().getSlot().isPresent()) {
                tubingGuiItem.setSlot(style.get().getSlot().get());
            }
            if (style.get().getMaterial().isPresent()) {
                tubingGuiItem.getTubingGuiItemStack().setMaterial(style.get().getMaterial().get());
            }
        }
        this.tubingGuiTextStyleParser.parse(tubingGuiItem.getTubingGuiItemStack().getName());
        for (TubingGuiText loreLine : tubingGuiItem.getTubingGuiItemStack().getLoreLines()) {
            this.tubingGuiTextStyleParser.parse(loreLine);
        }
    }
}

