/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.TubingGuiException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.style.StyleConfig;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.StyleId;
import net.shortninja.staffplus.libs.org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

@IocBean
public class StyleRepository {
    private static final List<String> STYLE_KEYS = Arrays.asList("hidden", "slot", "material", "size", "enchanted", "color");
    private final Map<String, StyleConfig> styleIds = new HashMap<String, StyleConfig>();
    private final Map<String, StyleConfig> styleClasses = new HashMap<String, StyleConfig>();

    public StyleRepository(@InjectTubingPlugin TubingPlugin tubingPlugin) {
        String directoryPath = tubingPlugin.getDataFolder() + File.separator + "styles";
        File styleDir = new File(directoryPath);
        if (!styleDir.exists()) {
            tubingPlugin.getLogger().info("No styles directory present");
            return;
        }
        for (File file : Objects.requireNonNull(styleDir.listFiles())) {
            if (file.isDirectory()) continue;
            FileConfiguration fileConfiguration = StyleRepository.loadConfiguration(file);
            this.registerStyleConfig((ConfigurationSection)fileConfiguration, "");
        }
    }

    private void registerStyleConfig(ConfigurationSection fileConfiguration, String parentKey) {
        StyleConfig defaultStyleConfig = this.mapStyleConfig(fileConfiguration);
        this.registerStyleConfig(parentKey, "", defaultStyleConfig);
        List validKeys = fileConfiguration.getKeys(false).stream().filter(k -> !STYLE_KEYS.contains(k)).collect(Collectors.toList());
        for (String key : validKeys) {
            this.registerStyleConfig(fileConfiguration.getConfigurationSection(key), parentKey.isEmpty() ? key : parentKey + "_" + key);
        }
    }

    private void registerStyleConfig(String idPrefix, String key, StyleConfig styleConfig) {
        String fullKey = idPrefix + key;
        String[] endSelector = fullKey.split("_");
        if (fullKey.startsWith("$") || endSelector[endSelector.length - 1].startsWith("$")) {
            this.styleClasses.put(fullKey, styleConfig);
        } else {
            this.styleIds.put(fullKey, styleConfig);
        }
    }

    private StyleConfig mapStyleConfig(ConfigurationSection section) {
        return new StyleConfig(section.contains("color") ? section.getString("color") : null, section.contains("material") ? Material.valueOf((String)section.getString("material")) : null, section.contains("hidden") ? Boolean.valueOf(section.getBoolean("hidden")) : null, section.contains("enchanted") ? Boolean.valueOf(section.getBoolean("enchanted")) : null, section.contains("slot") ? Integer.valueOf(section.getInt("slot")) : null, section.contains("size") ? Integer.valueOf(section.getInt("size")) : null);
    }

    public Optional<StyleConfig> getStyleConfigById(StyleId id) {
        if (id == null) {
            return Optional.empty();
        }
        List matchingClasses = this.styleClasses.keySet().stream().filter(id::matchesClassSelector).sorted(Comparator.comparingInt(c -> c.split("_").length)).collect(Collectors.toList());
        StyleConfig styleConfig = null;
        for (String matchingClass : matchingClasses) {
            if (styleConfig == null) {
                styleConfig = this.styleClasses.get(matchingClass);
                continue;
            }
            styleConfig = styleConfig.update(this.styleClasses.get(matchingClass));
        }
        Optional<String> matchingId = this.styleIds.keySet().stream().filter(id::matchesIdSelector).findFirst();
        if (matchingId.isPresent()) {
            styleConfig = styleConfig == null ? this.styleIds.get(matchingId.get()) : styleConfig.update(this.styleIds.get(matchingId.get()));
        }
        return Optional.ofNullable(styleConfig);
    }

    public static FileConfiguration loadConfiguration(File file) {
        Validate.notNull(file, "File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (Exception e) {
            throw new TubingGuiException("Cannot load " + file, e);
        }
        return config;
    }
}

