/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;

public class StyleId {
    private final StyleId parent;
    private String id;
    private List<String> classes;

    public StyleId(StyleId parent, String id, List<String> classes) {
        this.parent = parent;
        this.id = StringUtils.isNotBlank(id) ? id : null;
        this.classes = classes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void setId(String id) {
        this.id = id;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public boolean matchesIdSelector(String selector) {
        int index = selector.lastIndexOf("_");
        String last = selector;
        if (index > -1) {
            if (this.parent == null) {
                return false;
            }
            String parentSelector = selector.substring(0, index);
            last = selector.substring(index + 1);
            if (last.startsWith("$")) {
                boolean classMatched = this.classes.contains(last.replace("$", ""));
                return classMatched && this.parent.matchesIdSelector(parentSelector);
            }
            return this.id != null && this.id.equals(last) && this.parent.matchesIdSelector(parentSelector);
        }
        if (this.parent != null) {
            return false;
        }
        if (last.startsWith("$")) {
            return this.classes.contains(last.replace("$", ""));
        }
        return this.id != null && this.id.equals(last);
    }

    public boolean matchesClassSelector(String selector) {
        int index = selector.lastIndexOf("_");
        String last = selector;
        if (index > -1) {
            if (this.parent == null) {
                return false;
            }
            String parentSelector = selector.substring(0, index);
            last = selector.substring(index + 1);
            if (last.startsWith("$")) {
                boolean classMatched = this.classes.contains(last.replace("$", ""));
                return classMatched && this.parent.matchesClassSelector(parentSelector) || this.parent.matchesClassSelector(selector);
            }
            return this.id != null && this.id.equals(last) && this.parent.matchesClassSelector(parentSelector) || this.parent.matchesClassSelector(selector);
        }
        if (last.startsWith("$")) {
            return this.classes.contains(last.replace("$", ""));
        }
        return this.id != null && this.id.equals(last) || this.parent != null && this.parent.matchesClassSelector(last);
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public String toString() {
        return "StyleId{path='" + this.parent + '\'' + ", id='" + this.id + '\'' + ", classes=" + this.classes.stream().collect(Collectors.joining(",")) + '}';
    }
}

