/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Element;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;

@IocBean
public class InteractableSlotsXmlMapper {
    private static final String INTERACTABLE_SLOTS_ATTR = "interactableSlots";

    public List<Integer> map(Element tubingGuiElement) {
        if (StringUtils.isBlank(tubingGuiElement.attr(INTERACTABLE_SLOTS_ATTR))) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        List ranges = Arrays.stream(tubingGuiElement.attr(INTERACTABLE_SLOTS_ATTR).split(",")).collect(Collectors.toList());
        for (String range : ranges) {
            String[] split = range.split("\\.\\.");
            if (split.length > 2) {
                throw new RuntimeException("Invalid interactable slots configuration");
            }
            if (split.length == 1) {
                slots.add(Integer.parseInt(split[0]));
                continue;
            }
            IntStream.rangeClosed(Integer.parseInt(split[0]), Integer.parseInt(split[1])).forEach(slots::add);
        }
        return slots;
    }
}

