/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.Jsoup;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Attribute;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Document;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Element;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.parser.Parser;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.select.Elements;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.TubingGuiException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.TemplateConfigResolver;

@IocBean
public class TubingXmlConfigParser {
    private static final String CONFIG_PREFIX = "config|";
    private final TemplateConfigResolver templateConfigResolver;

    public TubingXmlConfigParser(TemplateConfigResolver templateConfigResolver) {
        this.templateConfigResolver = templateConfigResolver;
    }

    public String resolveConfigAttributes(String html) {
        Document document = Jsoup.parse(html, "", Parser.xmlParser());
        document.outputSettings().indentAmount(0).prettyPrint(false);
        Element tubingGuiElement = document.selectFirst("TubingGui");
        if (tubingGuiElement == null) {
            throw new TubingGuiException("Invalid html template. No TubingGui element found");
        }
        this.replaceAttributes(tubingGuiElement);
        Elements guiItems = tubingGuiElement.select("GuiItem");
        for (Element guiItem : guiItems) {
            this.replaceAttributes(guiItem);
            this.parseLoreLines(guiItem);
        }
        return document.toString();
    }

    private void parseLoreLines(Element guiItem) {
        Element loreElement = guiItem.selectFirst("Lore");
        if (loreElement != null) {
            this.replaceAttributes(loreElement);
            Elements loreLinesElements = loreElement.select("LoreLine");
            for (Element loreLineElement : loreLinesElements) {
                this.replaceAttributes(loreLineElement);
            }
        }
    }

    private void replaceAttributes(Element loreElement) {
        for (Attribute attribute : loreElement.attributes().asList()) {
            attribute.setValue(this.getAttrValue(attribute.getValue()));
        }
    }

    private String getAttrValue(String attributeValue) {
        if (attributeValue.startsWith(CONFIG_PREFIX)) {
            String configProperty = attributeValue.replace(CONFIG_PREFIX, "");
            return this.templateConfigResolver.get(configProperty).toString();
        }
        return attributeValue;
    }
}

