/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ConditionalOnMissingBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.Configuration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.DefaultObjectWrapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.Template;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateHashModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.TubingPermissionService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.TubingGuiException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplateResolver;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.TemplateConfigResolver;
import org.bukkit.entity.Player;

@IocBean
@ConditionalOnMissingBean
public class FreemarkerGuiTemplateResolver
implements GuiTemplateResolver {
    private final Configuration freemarkerConfiguration;
    private final TubingPlugin tubingPlugin;
    private final TemplateConfigResolver templateConfigResolver;
    private final DefaultObjectWrapper defaultObjectWrapper;
    private final TubingPermissionService tubingPermissionService;

    public FreemarkerGuiTemplateResolver(@InjectTubingPlugin TubingPlugin tubingPlugin, TemplateConfigResolver templateConfigResolver, TubingPermissionService tubingPermissionService) {
        this.tubingPlugin = tubingPlugin;
        this.templateConfigResolver = templateConfigResolver;
        this.tubingPermissionService = tubingPermissionService;
        this.freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_28);
        this.defaultObjectWrapper = new DefaultObjectWrapper(Configuration.VERSION_2_3_28);
        this.freemarkerConfiguration.setClassForTemplateLoading(tubingPlugin.getClass(), "/");
    }

    @Override
    public String resolve(Player player, String templatePath, Map<String, Object> params) {
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templatePath);
            TemplateHashModel statics = this.defaultObjectWrapper.getStaticModels();
            StringWriter stringWriter = new StringWriter();
            params.put("statics", statics);
            params.put("$config", this.templateConfigResolver);
            params.put("$permissions", this.tubingPermissionService);
            template.process(params, stringWriter);
            return stringWriter.toString();
        }
        catch (IOException | TemplateException e) {
            throw new TubingGuiException("Could not load template: [" + templatePath + "]", e);
        }
    }
}

