/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.Configuration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.DefaultObjectWrapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.Template;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateHashModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.Jsoup;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Document;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.nodes.Element;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.jsoup.select.Elements;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.TubingGuiException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingChatGui;
import org.bukkit.ChatColor;

@IocBean
public class ChatTemplateResolver {
    private final Configuration freemarkerConfiguration;
    private final DefaultObjectWrapper defaultObjectWrapper;
    private final ConfigurationLoader configurationLoader;

    public ChatTemplateResolver(@InjectTubingPlugin TubingPlugin tubingPlugin, ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
        this.freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_28);
        this.defaultObjectWrapper = new DefaultObjectWrapper(Configuration.VERSION_2_3_28);
        this.freemarkerConfiguration.setClassForTemplateLoading(tubingPlugin.getClass(), "/");
    }

    public TubingChatGui resolve(String templatePath) {
        return this.resolve(templatePath, new HashMap<String, Object>());
    }

    public TubingChatGui resolve(String templatePath, Map<String, Object> params) {
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templatePath);
            TemplateHashModel statics = this.defaultObjectWrapper.getStaticModels();
            StringWriter stringWriter = new StringWriter();
            Map<String, FileConfiguration> fileConfigurations = this.configurationLoader.getConfigurationFiles();
            fileConfigurations.forEach((k, v) -> {
                Set<String> keys = v.getKeys(true);
                for (String key : keys) {
                    params.put(k + ":" + key, v.get(key));
                    if (!k.equalsIgnoreCase("config")) continue;
                    params.put(key, v.get(key));
                }
            });
            params.put("statics", statics);
            template.process(params, stringWriter);
            return this.parseHtml(stringWriter.toString());
        }
        catch (IOException | TemplateException e) {
            throw new TubingGuiException("Could not load template: [" + templatePath + "]", e);
        }
    }

    private TubingChatGui parseHtml(String html) {
        Document document = Jsoup.parse(html);
        Element tubingGuiElement = document.selectFirst("TubingChatGui");
        String prefix = tubingGuiElement.attr("prefix");
        if (tubingGuiElement == null) {
            throw new TubingGuiException("Invalid html template. No TubingChatGui element found");
        }
        TubingChatGui.Builder builder = new TubingChatGui.Builder();
        Elements guiItems = tubingGuiElement.select("ChatLine");
        guiItems.stream().map(e -> this.format(prefix + e.text())).forEach(builder::addLine);
        return builder.build();
    }

    private String format(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

