/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.style;

import java.util.Optional;
import org.bukkit.Material;

public class StyleConfig {
    private String color;
    private Material material;
    private Boolean hidden;
    private Boolean enchanted;
    private Integer slot;
    private Integer size;

    public StyleConfig(String color, Material material, Boolean hidden, Boolean enchanted, Integer slot, Integer size) {
        this.color = color;
        this.material = material;
        this.hidden = hidden;
        this.enchanted = enchanted;
        this.slot = slot;
        this.size = size;
    }

    public Optional<String> getColor() {
        return Optional.ofNullable(this.color);
    }

    public Optional<Material> getMaterial() {
        return Optional.ofNullable(this.material);
    }

    public Optional<Boolean> isEnchanted() {
        return Optional.ofNullable(this.enchanted);
    }

    public Optional<Integer> getSize() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Boolean> isHidden() {
        return Optional.ofNullable(this.hidden);
    }

    public Optional<Integer> getSlot() {
        return Optional.ofNullable(this.slot);
    }

    public StyleConfig update(StyleConfig styleConfig) {
        StyleConfig result = this.duplicate();
        styleConfig.getSize().ifPresent(s -> {
            result.size = s;
        });
        styleConfig.getSlot().ifPresent(s -> {
            result.slot = s;
        });
        styleConfig.getMaterial().ifPresent(s -> {
            result.material = s;
        });
        styleConfig.getColor().ifPresent(s -> {
            result.color = s;
        });
        styleConfig.isHidden().ifPresent(s -> {
            result.hidden = s;
        });
        styleConfig.isEnchanted().ifPresent(s -> {
            result.enchanted = s;
        });
        return result;
    }

    private StyleConfig duplicate() {
        return new StyleConfig(this.color, this.material, this.hidden, this.enchanted, this.slot, this.size);
    }

    public String toString() {
        return "StyleConfig{color='" + this.color + '\'' + ", material=" + this.material + ", hidden=" + this.hidden + ", enchanted=" + this.enchanted + ", slot=" + this.slot + ", size=" + this.size + '}';
    }
}

