/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiItemStack;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.style.StyleId;

public class TubingGuiItem {
    private final StyleId id;
    private int slot;
    private final String leftClickAction;
    private final String rightClickAction;
    private final String leftShiftClickAction;
    private final String rightShiftClickAction;
    private final String middleClickAction;
    private final TubingGuiItemStack tubingGuiItemStack;
    private boolean hidden;

    public TubingGuiItem(StyleId id, int slot, String leftClickAction, String rightClickAction, String leftShiftClickAction, String rightShiftClickAction, String middleClickAction, TubingGuiItemStack itemStack, boolean hidden) {
        this.id = id;
        this.slot = slot;
        this.leftClickAction = leftClickAction;
        this.rightClickAction = rightClickAction;
        this.leftShiftClickAction = leftShiftClickAction;
        this.rightShiftClickAction = rightShiftClickAction;
        this.middleClickAction = middleClickAction;
        this.tubingGuiItemStack = itemStack;
        this.hidden = hidden;
    }

    public Optional<StyleId> getStyleId() {
        return Optional.ofNullable(this.id);
    }

    public String getLeftClickAction() {
        return this.leftClickAction;
    }

    public String getRightClickAction() {
        return this.rightClickAction;
    }

    public String getLeftShiftClickAction() {
        return this.leftShiftClickAction;
    }

    public String getRightShiftClickAction() {
        return this.rightShiftClickAction;
    }

    public String getMiddleClickAction() {
        return this.middleClickAction;
    }

    public int getSlot() {
        return this.slot;
    }

    public TubingGuiItemStack getTubingGuiItemStack() {
        return this.tubingGuiItemStack;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public static class Builder {
        private final StyleId id;
        private final int slot;
        private String leftClickAction = "$NOOP";
        private String rightClickAction = "$NOOP";
        private String leftShiftClickAction = "$NOOP";
        private String rightShiftClickAction = "$NOOP";
        private String middleClickAction = "$NOOP";
        private TubingGuiItemStack itemStack;
        private boolean hidden;

        public Builder(StyleId id, int slot) {
            this.id = id;
            this.slot = slot;
        }

        public Builder withLeftClickAction(String leftClickAction) {
            this.leftClickAction = leftClickAction;
            return this;
        }

        public Builder withRightClickAction(String rightClickAction) {
            this.rightClickAction = rightClickAction;
            return this;
        }

        public Builder withLeftShiftClickAction(String leftShiftClickAction) {
            this.leftShiftClickAction = leftShiftClickAction;
            return this;
        }

        public Builder withRightShiftClickAction(String rightShiftClickAction) {
            this.rightShiftClickAction = rightShiftClickAction;
            return this;
        }

        public Builder withMiddleClickAction(String middleClickAction) {
            this.middleClickAction = middleClickAction;
            return this;
        }

        public Builder withItemStack(TubingGuiItemStack itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        public Builder withHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public TubingGuiItem build() {
            return new TubingGuiItem(this.id, this.slot, this.leftClickAction, this.rightClickAction, this.leftShiftClickAction, this.rightShiftClickAction, this.middleClickAction, this.itemStack, this.hidden);
        }
    }
}

