/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TextMapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiItem;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiItemStack;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiText;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiTextPart;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.xml.MaterialUrlParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@IocBean
public class ItemStackMapper {
    public static final int LINE_LENGTH = 50;
    private final TextMapper textMapper;

    public ItemStackMapper(TextMapper textMapper) {
        this.textMapper = textMapper;
    }

    public ItemStack map(TubingGuiItem tubingGuiItem, boolean showIds) {
        ItemMeta meta;
        TubingGuiItemStack tubingGuiItemStack = tubingGuiItem.getTubingGuiItemStack();
        ItemStack itemStack = new ItemStack(tubingGuiItemStack.getMaterialUrl() == null ? tubingGuiItemStack.getMaterial() : Material.valueOf((String)"PLAYER_HEAD"));
        if (tubingGuiItemStack.getMaterialUrl() != null) {
            MaterialUrlParser.updateItemsStackWithCustomTexture(itemStack, tubingGuiItemStack.getMaterialUrl());
        }
        itemStack.setAmount(tubingGuiItemStack.getAmount());
        this.addName(itemStack, tubingGuiItem, tubingGuiItemStack.getName(), showIds);
        this.addLore(itemStack, tubingGuiItemStack.getLoreLines(), showIds);
        if (tubingGuiItemStack.isEnchanted()) {
            itemStack.addUnsafeEnchantment(Enchantment.DAMAGE_ALL, 1);
        }
        if ((meta = itemStack.getItemMeta()) != null) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    private void addName(ItemStack itemStack, TubingGuiItem tubingGuiItem, TubingGuiText name, boolean showIds) {
        ItemMeta itemMeta = this.getItemMeta(itemStack);
        if (name.isHidden()) {
            itemMeta.setDisplayName(this.getId(tubingGuiItem, showIds));
        } else {
            itemMeta.setDisplayName(this.getId(tubingGuiItem, showIds) + this.getClasses(tubingGuiItem, showIds) + this.textMapper.mapText(name).orElse(""));
        }
        itemStack.setItemMeta(itemMeta);
    }

    private ItemMeta getItemMeta(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            itemMeta = Bukkit.getItemFactory().getItemMeta(Material.PAPER);
        }
        return itemMeta;
    }

    private void addLore(ItemStack itemStack, List<TubingGuiText> lore, boolean showIds) {
        ItemMeta itemMeta = this.getItemMeta(itemStack);
        ArrayList<String> original = itemMeta.getLore();
        if (original == null) {
            original = new ArrayList<String>();
        }
        for (TubingGuiText itemStackLoreLine : lore) {
            this.textMapper.mapText(itemStackLoreLine).ifPresent(original::add);
            if (!showIds) continue;
            List<String> idLines = this.mapGuiId(itemStackLoreLine);
            original.addAll(idLines);
            List<String> classLines = this.mapGuiClasses(itemStackLoreLine);
            original.addAll(classLines);
        }
        itemMeta.setLore(original);
        itemStack.setItemMeta(itemMeta);
    }

    private List<String> mapGuiId(TubingGuiText itemStackLoreLine) {
        ArrayList<String> result = new ArrayList<String>();
        String partText = "";
        for (TubingGuiTextPart part : itemStackLoreLine.getParts()) {
            if (part.getId() == null || !part.getId().getId().isPresent()) continue;
            String idText = "&C(" + part.getId().getId().get() + ")";
            partText = this.parseLoreLine(result, partText, idText);
        }
        if (!partText.isEmpty()) {
            result.add(this.format(partText));
        }
        return result;
    }

    private List<String> mapGuiClasses(TubingGuiText itemStackLoreLine) {
        ArrayList<String> result = new ArrayList<String>();
        String partText = "";
        for (TubingGuiTextPart part : itemStackLoreLine.getParts()) {
            if (part.getId() == null || part.getId().getClasses().isEmpty()) continue;
            String classText = "&2(" + String.join((CharSequence)",", part.getId().getClasses()) + ")";
            partText = this.parseLoreLine(result, partText, classText);
        }
        if (!partText.isEmpty()) {
            result.add(this.format(partText));
        }
        return result;
    }

    private String parseLoreLine(List<String> result, String partText, String classText) {
        String line = partText + classText;
        if (line.length() > 50 && classText.length() <= 50) {
            if (!partText.isEmpty()) {
                result.add(this.format(partText));
            }
            partText = classText;
        } else if (line.length() > 50) {
            result.add(this.format(line));
            partText = "";
        } else {
            partText = line;
        }
        return partText;
    }

    private String format(String loreLine) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine);
    }

    private String getId(TubingGuiItem tubingGui, boolean showIds) {
        if (!(showIds && tubingGui.getStyleId().isPresent() && tubingGui.getStyleId().get().getId().isPresent())) {
            return "";
        }
        return this.format("&C(" + tubingGui.getStyleId().get().getId().get().split("_")[0] + ") ");
    }

    private String getClasses(TubingGuiItem tubingGui, boolean showIds) {
        if (!showIds || !tubingGui.getStyleId().isPresent() || tubingGui.getStyleId().get().getClasses().isEmpty()) {
            return "";
        }
        return this.format("&2(" + String.join((CharSequence)",", tubingGui.getStyleId().get().getClasses()) + ") ");
    }
}

