/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.ItemStackMapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TextMapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGuiItem;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;

@IocBean
public class InventoryMapper {
    private final ItemStackMapper itemStackMapper;
    private final TextMapper textMapper;

    public InventoryMapper(ItemStackMapper itemStackMapper, TextMapper textMapper) {
        this.itemStackMapper = itemStackMapper;
        this.textMapper = textMapper;
    }

    public Inventory map(TubingGui tubingGui, boolean showIds) {
        Inventory inventory = Bukkit.createInventory(null, (int)tubingGui.getSize(), (String)(this.getId(tubingGui, showIds) + this.textMapper.mapText(tubingGui.getTitle()).orElse("")));
        tubingGui.getGuiItems().values().stream().filter(guiItem -> !guiItem.isHidden()).forEach(guiItem -> inventory.setItem(guiItem.getSlot(), this.itemStackMapper.map((TubingGuiItem)guiItem, showIds)));
        return inventory;
    }

    private String getId(TubingGui tubingGui, boolean showIds) {
        if (!showIds || !tubingGui.getId().isPresent()) {
            return "";
        }
        return "(" + tubingGui.getId().get().getId().orElse("No ID") + ") ";
    }
}

