/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.history.GuiHistoryStack;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;

@IocBukkitListener
public class InventoryClose
implements Listener {
    private final TubingPlugin tubingPlugin;
    private final GuiActionService actionService;
    private final GuiHistoryStack historyStack;

    public InventoryClose(@InjectTubingPlugin TubingPlugin tubingPlugin, GuiActionService guiActionService, GuiHistoryStack guiHistoryStack) {
        this.tubingPlugin = tubingPlugin;
        this.actionService = guiActionService;
        this.historyStack = guiHistoryStack;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Optional<TubingGui> tubingGui = this.actionService.getTubingGui(player);
        if (tubingGui.isPresent() && event.getInventory().equals(tubingGui.get().getInventory())) {
            String closeAction = tubingGui.get().getCloseAction();
            if (!this.actionService.isOpeningInventory.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                this.actionService.isOpeningInventory.put(player.getUniqueId(), false);
                if (this.closeActionDefined(closeAction) && !this.historyStack.isLastAction(player.getUniqueId(), closeAction)) {
                    this.actionService.executeAction(player, closeAction);
                    return;
                }
                this.historyStack.clear(player.getUniqueId());
            }
            this.actionService.removeInventory(player);
        }
    }

    private boolean closeActionDefined(String closeAction) {
        return StringUtils.isNotBlank(closeAction) && !closeAction.equals("$NOOP");
    }
}

