/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocContainer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ReflectionUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.common.ITubingBukkitUtil;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionConfig;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.actionquery.ActionQueryParser;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.actionquery.GuiActionQuery;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.GuiExceptionHandler;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.exceptions.GuiExceptionHandlerProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.history.GuiHistoryStack;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.InventoryMapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingChatGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.style.TubingGuiStyleIdViewProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.ChatTemplate;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.ChatTemplateResolver;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplateProcessor;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

@IocBean
public class GuiActionService {
    private final Map<String, GuiActionConfig> guiActions = new HashMap<String, GuiActionConfig>();
    private final Map<UUID, TubingGui> inventories = new HashMap<UUID, TubingGui>();
    public final Map<UUID, Boolean> isOpeningInventory = new HashMap<UUID, Boolean>();
    private final Map<Class<? extends Exception>, GuiExceptionHandler> exceptionHandlers = new HashMap<Class<? extends Exception>, GuiExceptionHandler>();
    private final TubingPlugin tubingPlugin;
    private final ConfigurationLoader configurationLoader;
    private final GuiTemplateProcessor guiTemplateProcessor;
    private final ChatTemplateResolver chatTemplateResolver;
    private final ActionQueryParser actionQueryParser;
    private final ITubingBukkitUtil tubingBukkitUtil;
    private final InventoryMapper inventoryMapper;
    private final TubingGuiStyleIdViewProvider tubingGuiStyleIdViewProvider;
    private final GuiHistoryStack guiHistoryStack;

    public GuiActionService(@InjectTubingPlugin TubingPlugin tubingPlugin, ConfigurationLoader configurationLoader, GuiTemplateProcessor guiTemplateProcessor, ChatTemplateResolver chatTemplateResolver, ActionQueryParser actionQueryParser, ITubingBukkitUtil tubingBukkitUtil, InventoryMapper inventoryMapper, TubingGuiStyleIdViewProvider tubingGuiStyleIdViewProvider, GuiHistoryStack guiHistoryStack, @IocMulti(value=GuiExceptionHandler.class) List<GuiExceptionHandler> providedExceptionHandlers) {
        this.tubingPlugin = tubingPlugin;
        this.configurationLoader = configurationLoader;
        this.guiTemplateProcessor = guiTemplateProcessor;
        this.chatTemplateResolver = chatTemplateResolver;
        this.actionQueryParser = actionQueryParser;
        this.tubingBukkitUtil = tubingBukkitUtil;
        this.inventoryMapper = inventoryMapper;
        this.tubingGuiStyleIdViewProvider = tubingGuiStyleIdViewProvider;
        this.guiHistoryStack = guiHistoryStack;
        this.registerExceptionHandlers(providedExceptionHandlers);
    }

    private void registerExceptionHandlers(List<GuiExceptionHandler> providedExceptionHandlers) {
        for (GuiExceptionHandler providedExceptionHandler : providedExceptionHandlers) {
            Arrays.stream(providedExceptionHandler.getClass().getAnnotations()).filter(a2 -> a2.annotationType().equals(GuiExceptionHandlerProvider.class)).map(a2 -> (GuiExceptionHandlerProvider)a2).findFirst().ifPresent(a2 -> Arrays.stream(a2.exceptions()).forEach(aClass -> this.registerExceptionHandler((Class<? extends Exception>)aClass, providedExceptionHandler)));
        }
    }

    public void setInventory(Player player, TubingGui tubingGui) {
        this.inventories.put(player.getUniqueId(), tubingGui);
    }

    public Optional<TubingGui> getTubingGui(Player player) {
        return Optional.ofNullable(this.inventories.get(player.getUniqueId()));
    }

    public void registerExceptionHandler(Class<? extends Exception> clazz, GuiExceptionHandler guiExceptionHandler) {
        this.exceptionHandlers.put(clazz, guiExceptionHandler);
    }

    public void executeAction(Player player, String actionQuery) {
        block9: {
            try {
                if (actionQuery.equalsIgnoreCase("$BACK")) {
                    Optional<String> backAction = this.guiHistoryStack.pop(player.getUniqueId());
                    if (backAction.isPresent()) {
                        this.executeAction(player, backAction.get());
                        return;
                    }
                    player.closeInventory();
                    this.removeInventory(player);
                    return;
                }
                GuiActionQuery guiActionQuery = new GuiActionQuery(actionQuery);
                if (!this.guiActions.containsKey(guiActionQuery.getRoute())) {
                    throw new IocException("No Gui Action found for [" + guiActionQuery.getRoute() + "]");
                }
                GuiActionConfig guiActionConfig = this.guiActions.get(guiActionQuery.getRoute());
                Method method = guiActionConfig.getMethod();
                Object[] methodParams = this.actionQueryParser.getMethodParams(method, guiActionQuery, player, this.getTubingGui(player).orElse(null));
                Object bean = this.tubingPlugin.getIocContainer().get(method.getDeclaringClass());
                if (bean == null) {
                    throw new IocException("No GuiController found to handle action [" + actionQuery + "]. Tried finding [" + method.getClass() + "]");
                }
                try {
                    Object invokedReturnedObject = method.invoke(bean, methodParams);
                    if (invokedReturnedObject instanceof AsyncGui) {
                        this.processAsyncGuiAction(player, guiActionQuery, guiActionConfig, method, (AsyncGui)invokedReturnedObject);
                        break block9;
                    }
                    this.processGuiAction(player, guiActionQuery, guiActionConfig, method, invokedReturnedObject);
                }
                catch (InvocationTargetException e) {
                    this.handleException(player, e.getCause());
                }
            }
            catch (Throwable e) {
                throw new IocException("Unable to execute gui action", e);
            }
        }
    }

    private void processAsyncGuiAction(Player player, GuiActionQuery actionQuery, GuiActionConfig guiActionConfig, Method method, AsyncGui invokedReturnedObject) {
        this.tubingBukkitUtil.runAsync(() -> {
            try {
                AsyncGui asyncGui = invokedReturnedObject;
                Object run = asyncGui.getAsyncGuiExecutor().run();
                this.tubingBukkitUtil.runTaskLater(() -> this.processGuiAction(player, actionQuery, guiActionConfig, method, run), 1);
            }
            catch (Throwable e) {
                try {
                    this.handleException(player, e);
                }
                catch (Throwable throwable) {
                    throw new IocException("Unable to execute gui action", e);
                }
            }
        });
    }

    private void handleException(Player player, Throwable e) throws Throwable {
        if (this.exceptionHandlers.containsKey(e.getClass())) {
            this.exceptionHandlers.get(e.getClass()).accept(player, e);
            player.closeInventory();
            this.removeInventory(player);
            this.guiHistoryStack.clear(player.getUniqueId());
            return;
        }
        Optional<Class> parentException = this.exceptionHandlers.keySet().stream().filter(c -> c.isAssignableFrom(e.getClass())).findFirst();
        if (parentException.isPresent()) {
            this.exceptionHandlers.get(parentException.get()).accept(player, e);
            player.closeInventory();
            this.removeInventory(player);
            this.guiHistoryStack.clear(player.getUniqueId());
            return;
        }
        throw e;
    }

    private void processGuiAction(Player player, GuiActionQuery actionQuery, GuiActionConfig guiActionConfig, Method method, Object invokedReturnedObject) {
        this.guiHistoryStack.push(player.getUniqueId(), actionQuery, guiActionConfig.isOverrideHistory(), guiActionConfig.isSkipHistory());
        if (invokedReturnedObject instanceof TubingGui) {
            TubingGui tubingGui = (TubingGui)invokedReturnedObject;
            this.showGui(player, tubingGui);
        } else if (invokedReturnedObject == null) {
            player.closeInventory();
            this.removeInventory(player);
            this.guiHistoryStack.clear(player.getUniqueId());
        } else if (invokedReturnedObject instanceof GuiActionReturnType) {
            GuiActionReturnType actionReturnType = (GuiActionReturnType)((Object)invokedReturnedObject);
            if (actionReturnType == GuiActionReturnType.BACK) {
                this.executeAction(player, "$BACK");
            } else if (actionReturnType != GuiActionReturnType.KEEP_OPEN) {
                player.closeInventory();
                this.removeInventory(player);
            }
        } else if (invokedReturnedObject instanceof GuiTemplate) {
            GuiTemplate guiTemplate = (GuiTemplate)invokedReturnedObject;
            this.addTemplateParams(player, actionQuery, method, guiTemplate.getParams());
            this.showGuiTemplate(player, guiTemplate, actionQuery, guiActionConfig);
        } else if (invokedReturnedObject instanceof ChatTemplate) {
            ChatTemplate chatTemplate = (ChatTemplate)invokedReturnedObject;
            this.addTemplateParams(player, actionQuery, method, chatTemplate.getParams());
            this.showChatTemplate(player, chatTemplate);
            this.guiHistoryStack.clear(player.getUniqueId());
        } else if (invokedReturnedObject instanceof String) {
            String redirectAction = (String)invokedReturnedObject;
            this.executeAction(player, redirectAction);
        } else {
            throw new IocException("Invalid returnType [" + invokedReturnedObject.getClass() + "] for GuiController [" + method.getDeclaringClass() + "]");
        }
    }

    public void showGuiTemplate(Player player, GuiTemplate guiTemplate, GuiActionQuery actionQuery, GuiActionConfig guiActionConfig) {
        this.showGui(player, this.guiTemplateProcessor.process(player, guiTemplate.getTemplate(), guiTemplate.getParams()));
    }

    public void showChatTemplate(Player player, ChatTemplate chatTemplate) {
        this.showChat(player, this.chatTemplateResolver.resolve(chatTemplate.getTemplate(), chatTemplate.getParams()));
    }

    public void showGui(Player player, TubingGui tubingGui) {
        this.tubingBukkitUtil.runTaskLater(() -> {
            this.isOpeningInventory.put(player.getUniqueId(), true);
            player.closeInventory();
            boolean showId = this.tubingGuiStyleIdViewProvider.canView(player);
            Inventory inventory = this.inventoryMapper.map(tubingGui, showId);
            tubingGui.setInventory(inventory);
            player.openInventory(inventory);
            this.setInventory(player, tubingGui);
            this.isOpeningInventory.put(player.getUniqueId(), false);
        }, 1);
    }

    public void showChat(Player player, TubingChatGui tubingChatGui) {
        this.tubingBukkitUtil.runTaskLater(() -> {
            for (String chatLine : tubingChatGui.getChatLines()) {
                player.sendMessage(chatLine);
            }
        }, 1);
    }

    private Map<String, Object> getTemplateParams(Method method, GuiActionQuery actionQuery, Player player) {
        HashMap<String, Object> methodParams = new HashMap<String, Object>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            Optional<Annotation> paramAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(GuiParam.class)).findFirst();
            if (!paramAnnotation.isPresent()) continue;
            GuiParam param = (GuiParam)paramAnnotation.get();
            if (actionQuery.getParams().containsKey(param.value())) {
                methodParams.put(param.value(), this.toObject(parameterTypes[i], actionQuery.getParams().get(param.value())));
                continue;
            }
            if (!StringUtils.isNotBlank(param.defaultValue())) continue;
            methodParams.put(param.value(), this.toObject(parameterTypes[i], param.defaultValue()));
        }
        methodParams.put("player", player);
        methodParams.put("currentAction", actionQuery.getFullQuery());
        actionQuery.getParams().forEach((k, v) -> {
            if (!methodParams.containsKey(k)) {
                methodParams.put((String)k, v);
            }
        });
        return methodParams;
    }

    private Object toObject(Class clazz, String value) {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            return Byte.parseByte(value);
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return Short.parseShort(value);
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return Integer.parseInt(value);
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            return Long.parseLong(value);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return Double.parseDouble(value);
        }
        return value;
    }

    public void loadGuiControllers(IocContainer iocContainer) {
        List<Class<?>> typesAnnotatedWith = iocContainer.getReflections().getClassesWithAnnotation(GuiController.class).loadClasses();
        typesAnnotatedWith.forEach(this::loadGuiController);
    }

    public void loadGuiController(Class guiController) {
        List<Method> actionMethods = ReflectionUtils.getMethodsAnnotatedWith(guiController, GuiAction.class);
        for (Method actionMethod : actionMethods) {
            GuiAction annotation = actionMethod.getAnnotation(GuiAction.class);
            String value = annotation.value();
            boolean overrideHistory = annotation.overrideHistory();
            boolean skipHistory = annotation.skipHistory();
            if (this.guiActions.containsKey(value)) {
                throw new IocException("Duplicate GUI action defined: [" + value + "]");
            }
            this.guiActions.put(value, new GuiActionConfig(value, actionMethod, overrideHistory, skipHistory));
        }
    }

    public void removeInventory(Player player) {
        this.inventories.remove(player.getUniqueId());
    }

    private void addTemplateParams(Player player, GuiActionQuery actionQuery, Method method, Map<String, Object> params) {
        Map<String, Object> templateParams = this.getTemplateParams(method, actionQuery, player);
        templateParams.forEach((k, v) -> {
            if (!params.containsKey(k)) {
                params.put((String)k, v);
            }
        });
    }
}

