/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;

public class GuiActionBuilder {
    private Map<String, String> params = new HashMap<String, String>();
    private String action;

    public static GuiActionBuilder builder() {
        return new GuiActionBuilder();
    }

    public static GuiActionBuilder fromAction(String actionQuery) {
        String[] split = actionQuery.split(Pattern.quote("?"), 2);
        GuiActionBuilder actionBuilder = new GuiActionBuilder();
        actionBuilder.action = split[0];
        actionBuilder.params = GuiActionBuilder.getParams(actionQuery);
        return actionBuilder;
    }

    private static Map<String, String> getParams(String actionQuery) {
        String[] split = actionQuery.split(Pattern.quote("?"), 2);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (split.length > 1) {
            String[] queryParams;
            for (String queryParam : queryParams = split[1].split("&")) {
                String[] paramKeyValue = queryParam.split("=");
                paramMap.put(paramKeyValue[0], paramKeyValue[1]);
            }
        }
        return paramMap;
    }

    public GuiActionBuilder action(String action) {
        this.action = action;
        return this;
    }

    public GuiActionBuilder param(String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            String encode = URLEncoder.encode(value);
            this.params.put(key, encode);
        }
        return this;
    }

    public String build() {
        if (this.params.isEmpty()) {
            return this.action;
        }
        String result = this.action + "?";
        List queryParams = this.params.keySet().stream().map(key -> key + "=" + this.params.get(key)).collect(Collectors.toList());
        return result + String.join((CharSequence)"&", queryParams);
    }
}

