/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.messaging;

import java.util.Collection;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.messaging.MessagePrefixProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.messaging.PlaceholderService;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class Messages {
    private static final String NO_PREFIX = "[NO_PREFIX]";
    private final PlaceholderService placeholderService;
    private final MessagePrefixProvider messagePrefixProvider;
    private final ConfigurationLoader configurationLoader;

    public Messages(PlaceholderService placeholderService, MessagePrefixProvider messagePrefixProvider, ConfigurationLoader configurationLoader) {
        this.placeholderService = placeholderService;
        this.messagePrefixProvider = messagePrefixProvider;
        this.configurationLoader = configurationLoader;
    }

    public String colorize(String message) {
        message = message.replace("&&", "<ampersand>");
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message.replace("<ampersand>", "&");
    }

    public String parse(Player player, String message) {
        if (this.isEmpty(message)) {
            return "";
        }
        return this.colorize(this.placeholderService.setPlaceholders(player, message));
    }

    public void sendNoPrefix(CommandSender sender, String message) {
        if (this.isEmpty(message)) {
            return;
        }
        message = this.placeholderService.setPlaceholders(sender, message);
        for (String s : message.split("\\n")) {
            sender.sendMessage(this.buildMessage("", s));
        }
    }

    public void send(CommandSender sender, String message) {
        if (this.isEmpty(message)) {
            return;
        }
        message = this.placeholderService.setPlaceholders(sender, message);
        for (String s : message.split("\\n")) {
            sender.sendMessage(this.buildMessage(this.getPrefix(), s));
        }
    }

    public void broadcast(String message) {
        if (this.isEmpty(message)) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(receiver -> this.send((CommandSender)receiver, message));
    }

    public void send(Collection<? extends Player> receivers, String message) {
        if (this.isEmpty(message)) {
            return;
        }
        receivers.forEach(receiver -> this.send((CommandSender)receiver, message));
    }

    public void send(Player player, String message, String permission) {
        if (this.isEmpty(message)) {
            return;
        }
        if (!player.hasPermission(permission)) {
            return;
        }
        this.send((CommandSender)player, message);
    }

    public void send(CommandSender sender, List<String> messageLines) {
        messageLines.forEach(message -> this.send(sender, (String)message));
    }

    public void sendGlobalMessage(String message) {
        Bukkit.broadcastMessage((String)this.buildMessage(this.getPrefix(), message));
    }

    public void sendGroupMessage(String message, String permission) {
        if (this.isEmpty(message)) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> this.send((Player)player, message, permission));
    }

    private String buildMessage(String prefix, String message) {
        if (message.startsWith(NO_PREFIX)) {
            prefix = "";
            message = message.replace(NO_PREFIX, "");
        }
        if (StringUtils.isEmpty(prefix)) {
            return this.colorize(message);
        }
        return this.colorize(prefix + " " + message);
    }

    private String getPrefix() {
        return this.messagePrefixProvider.getPrefix();
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

