/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.load;

import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.TubingBukkitPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitCommandHandler;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class TubingBukkitBeanLoader {
    public static void load(TubingPlugin tubingPlugin) {
        TubingBukkitBeanLoader.loadCommandHandlerBeans(tubingPlugin);
        TubingBukkitBeanLoader.loadListenerBeans(tubingPlugin);
        TubingBukkitBeanLoader.loadMessageListenerBeans(tubingPlugin);
    }

    private static void loadCommandHandlerBeans(TubingPlugin tubingPlugin) {
        List<Class<?>> typesAnnotatedWith = tubingPlugin.getIocContainer().getReflections().getClassesWithAnnotation(IocBukkitCommandHandler.class).loadClasses();
        for (Class<?> aClass : typesAnnotatedWith) {
            if (!CommandExecutor.class.isAssignableFrom(aClass)) {
                throw new IocException("IocCommandHandler annotation can only be used on CommandExecutors");
            }
            if (tubingPlugin.getIocContainer().get(aClass) == null) continue;
            CommandExecutor bean = (CommandExecutor)tubingPlugin.getIocContainer().get(aClass);
            IocBukkitCommandHandler annotation = aClass.getAnnotation(IocBukkitCommandHandler.class);
            TubingBukkitPlugin.getPlugin().getCommand(annotation.value()).setExecutor(bean);
        }
    }

    private static void loadListenerBeans(TubingPlugin tubingPlugin) {
        List<Class<?>> typesAnnotatedWith = tubingPlugin.getIocContainer().getReflections().getClassesWithAnnotation(IocBukkitListener.class).loadClasses();
        for (Class<?> aClass : typesAnnotatedWith) {
            if (!Listener.class.isAssignableFrom(aClass)) {
                throw new IocException("IocListener annotation can only be used on bukkit Listeners. Failing class [" + aClass + "]");
            }
            if (tubingPlugin.getIocContainer().get(aClass) == null) continue;
            Listener bean = (Listener)tubingPlugin.getIocContainer().get(aClass);
            Bukkit.getPluginManager().registerEvents(bean, (Plugin)TubingBukkitPlugin.getPlugin());
        }
    }

    private static void loadMessageListenerBeans(TubingPlugin tubingPlugin) {
        List<Class<?>> typesAnnotatedWith = tubingPlugin.getIocContainer().getReflections().getClassesWithAnnotation(IocBukkitMessageListener.class).loadClasses();
        for (Class<?> aClass : typesAnnotatedWith) {
            if (!PluginMessageListener.class.isAssignableFrom(aClass)) {
                throw new IocException("IocMessageListener annotation can only be used on bukkit PluginMessageListeners");
            }
            if (tubingPlugin.getIocContainer().get(aClass) == null) continue;
            PluginMessageListener bean = (PluginMessageListener)tubingPlugin.getIocContainer().get(aClass);
            IocBukkitMessageListener annotation = aClass.getAnnotation(IocBukkitMessageListener.class);
            Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)TubingBukkitPlugin.getPlugin(), annotation.channel(), bean);
        }
    }
}

