/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitSubCommand;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.exceptions.TubingBukkitException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.NoPermissionException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.TubingPermissionService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public interface SubCommand {
    default public void onCommand(CommandSender sender, String[] args, TubingPermissionService permissionService) {
        this.validateOnlyPlayers(sender);
        this.validatePermission(sender, permissionService);
        this.executeCmd(sender, args);
    }

    public boolean executeCmd(CommandSender var1, String[] var2);

    public String getHelp();

    default public void validatePermission(CommandSender sender, TubingPermissionService permissionService) {
        String permission;
        if (this.getClass().isAnnotationPresent(IocBukkitSubCommand.class) && !(permission = this.getClass().getAnnotation(IocBukkitSubCommand.class).permission()).isEmpty() && !permissionService.has(sender, permission)) {
            throw new NoPermissionException("You don't have permission to execute this command");
        }
    }

    default public void validateOnlyPlayers(CommandSender sender) {
        boolean onlyPlayers = false;
        if (this.getClass().isAnnotationPresent(IocBukkitSubCommand.class)) {
            onlyPlayers = this.getClass().getAnnotation(IocBukkitSubCommand.class).onlyPlayers();
        }
        if (onlyPlayers && !(sender instanceof Player)) {
            throw new TubingBukkitException("Can only be executed by Players");
        }
    }
}

