/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitCommandHandler;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitSubCommand;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands.AbstractCmd;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands.SubCommand;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands.exceptions.CommandException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands.exceptions.CommandExceptionHandler;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.messaging.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.TubingPermissionService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public abstract class RootCommand
extends AbstractCmd
implements TabCompleter {
    protected final List<SubCommand> subCommands;
    private final Messages messages;
    private final TubingPermissionService permissionService;

    public RootCommand(CommandExceptionHandler commandExceptionHandler, @IocMulti(value=SubCommand.class) List<SubCommand> subCommands, Messages messages, TubingPermissionService permissionService) {
        super(commandExceptionHandler, permissionService);
        this.subCommands = subCommands.stream().filter(s -> s.getClass().getAnnotation(IocBukkitSubCommand.class).root().equalsIgnoreCase(this.getRootId())).collect(Collectors.toList());
        this.messages = messages;
        this.permissionService = permissionService;
    }

    private String getRootId() {
        return this.getClass().getAnnotation(IocBukkitCommandHandler.class).value();
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args) {
        if (args.length < 1) {
            this.onZeroArguments(sender);
            return true;
        }
        String action = args[0];
        if (action.equalsIgnoreCase("help")) {
            this.onHelp(sender);
            return true;
        }
        SubCommand subCommand = this.subCommands.stream().filter(s -> s.getClass().getAnnotation(IocBukkitSubCommand.class).action().equalsIgnoreCase(action)).findFirst().orElseThrow(() -> new CommandException("Invalid command action"));
        subCommand.onCommand(sender, Arrays.copyOfRange(args, 1, args.length), this.permissionService);
        return true;
    }

    protected void onHelp(CommandSender sender) {
        this.messages.send(sender, "&2" + this.getRootId() + " help");
        this.subCommands.forEach(subCommand -> this.messages.send(sender, subCommand.getHelp()));
    }

    protected void onZeroArguments(CommandSender sender) {
        this.onHelp(sender);
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String alias, String[] strings) {
        if (strings.length == 1) {
            List<String> result = this.subCommands.stream().map(s -> s.getClass().getAnnotation(IocBukkitSubCommand.class).action()).collect(Collectors.toList());
            result.add("help");
            return result;
        }
        return Collections.emptyList();
    }
}

