/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitCommandHandler;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands.exceptions.CommandException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.commands.exceptions.CommandExceptionHandler;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.exceptions.TubingBukkitException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.NoPermissionException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.permissions.TubingPermissionService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractCmd
implements CommandExecutor {
    private final CommandExceptionHandler commandExceptionHandler;
    private final TubingPermissionService permissionService;

    protected AbstractCmd(CommandExceptionHandler commandExceptionHandler, TubingPermissionService permissionService) {
        this.commandExceptionHandler = commandExceptionHandler;
        this.permissionService = permissionService;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        try {
            this.validateOnlyPlayers(sender);
            this.validatePermission(sender);
            this.validateMinimumArguments(sender, args);
            return this.executeCmd(sender, alias, args);
        }
        catch (Throwable e) {
            this.commandExceptionHandler.handle(sender, e);
            return false;
        }
    }

    private void validateOnlyPlayers(CommandSender sender) {
        boolean onlyPlayers = false;
        if (this.getClass().isAnnotationPresent(IocBukkitCommandHandler.class)) {
            onlyPlayers = this.getClass().getAnnotation(IocBukkitCommandHandler.class).onlyPlayers();
        }
        if (onlyPlayers && !(sender instanceof Player)) {
            throw new TubingBukkitException("Can only be executed by Players");
        }
    }

    private void validatePermission(CommandSender sender) {
        String permission = "";
        if (this.getClass().isAnnotationPresent(IocBukkitCommandHandler.class)) {
            permission = this.getClass().getAnnotation(IocBukkitCommandHandler.class).permission();
        }
        if (!permission.isEmpty() && !this.permissionService.has(sender, permission)) {
            throw new NoPermissionException("You don't have permission to execute this command");
        }
    }

    protected abstract boolean executeCmd(CommandSender var1, String var2, String[] var3);

    protected abstract int getMinimumArguments(CommandSender var1, String[] var2);

    private void validateMinimumArguments(CommandSender sender, String[] args) {
        if (args.length < this.getMinimumArguments(sender, args)) {
            throw new CommandException("Arguments invalid.");
        }
    }
}

