/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.beans.BeansWrapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.beans.DateModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonHashModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonNumberModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonSequenceModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonVersionAdapter;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonVersionAdapterHolder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.jython.JythonWrapper;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.ext.util.ModelCache;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModel;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyStringMap;

class JythonModelCache
extends ModelCache {
    private final JythonWrapper wrapper;

    JythonModelCache(JythonWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    protected boolean isCacheable(Object object) {
        return true;
    }

    @Override
    protected TemplateModel create(Object obj) {
        boolean asHash = false;
        boolean asSequence = false;
        JythonVersionAdapter versionAdapter = JythonVersionAdapterHolder.INSTANCE;
        if (versionAdapter.isPyInstance(obj)) {
            Object jobj = versionAdapter.pyInstanceToJava(obj);
            if (jobj instanceof TemplateModel) {
                return (TemplateModel)jobj;
            }
            if (jobj instanceof Map) {
                asHash = true;
            }
            if (jobj instanceof Date) {
                return new DateModel((Date)jobj, BeansWrapper.getDefaultInstance());
            }
            if (jobj instanceof Collection) {
                asSequence = true;
                if (!(jobj instanceof List)) {
                    obj = new ArrayList((Collection)jobj);
                }
            }
        }
        if (!(obj instanceof PyObject)) {
            obj = Py.java2py((Object)obj);
        }
        if (asHash || obj instanceof PyDictionary || obj instanceof PyStringMap) {
            return JythonHashModel.FACTORY.create(obj, this.wrapper);
        }
        if (asSequence || obj instanceof PySequence) {
            return JythonSequenceModel.FACTORY.create(obj, this.wrapper);
        }
        if (obj instanceof PyInteger || obj instanceof PyLong || obj instanceof PyFloat) {
            return JythonNumberModel.FACTORY.create(obj, this.wrapper);
        }
        if (obj instanceof PyNone) {
            return null;
        }
        return JythonModel.FACTORY.create(obj, this.wrapper);
    }
}

