/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core;

import java.text.NumberFormat;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.BackwardCompatibleTemplateNumberFormat;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateFormatUtil;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.UnformattableValueException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModelException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateNumberModel;

final class JavaTemplateNumberFormat
extends BackwardCompatibleTemplateNumberFormat {
    private final String formatString;
    private final NumberFormat javaNumberFormat;

    public JavaTemplateNumberFormat(NumberFormat javaNumberFormat, String formatString) {
        this.formatString = formatString;
        this.javaNumberFormat = javaNumberFormat;
    }

    @Override
    public String formatToPlainText(TemplateNumberModel numberModel) throws UnformattableValueException, TemplateModelException {
        Number number = TemplateFormatUtil.getNonNullNumber(numberModel);
        return this.format(number);
    }

    @Override
    public boolean isLocaleBound() {
        return true;
    }

    @Override
    String format(Number number) throws UnformattableValueException {
        try {
            return this.javaNumberFormat.format(number);
        }
        catch (ArithmeticException e) {
            throw new UnformattableValueException("This format can't format the " + number + " number. Reason: " + e.getMessage(), e);
        }
    }

    public NumberFormat getJavaNumberFormat() {
        return this.javaNumberFormat;
    }

    @Override
    public String getDescription() {
        return this.formatString;
    }
}

