/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.DynamicKeyName;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.Environment;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.Expression;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.NumberLiteral;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.OutputFormatBoundBuiltIn;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.ParserConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.UnexpectedTypeException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core._DelayedGetMessage;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core._MiscTemplateException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core._ParserConfigurationWithInheritedFormat;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core._TemplateModelException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.Template;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModelException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateScalarModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateSequenceModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateTransformModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template._TemplateAPI;

class Interpret
extends OutputFormatBoundBuiltIn {
    Interpret() {
    }

    @Override
    protected TemplateModel calculateResult(Environment env) throws TemplateException {
        Template interpretedTemplate;
        TemplateModel model = this.target.eval(env);
        Expression sourceExpr = null;
        String id = "anonymous_interpreted";
        if (model instanceof TemplateSequenceModel) {
            sourceExpr = (Expression)new DynamicKeyName(this.target, new NumberLiteral(0)).copyLocationFrom(this.target);
            if (((TemplateSequenceModel)model).size() > 1) {
                id = ((Expression)new DynamicKeyName(this.target, new NumberLiteral(1)).copyLocationFrom(this.target)).evalAndCoerceToPlainText(env);
            }
        } else if (model instanceof TemplateScalarModel) {
            sourceExpr = this.target;
        } else {
            throw new UnexpectedTypeException(this.target, model, "sequence or string", new Class[]{TemplateSequenceModel.class, TemplateScalarModel.class}, env);
        }
        String templateSource = sourceExpr.evalAndCoerceToPlainText(env);
        Template parentTemplate = env.getConfiguration().getIncompatibleImprovements().intValue() >= _TemplateAPI.VERSION_INT_2_3_26 ? env.getCurrentTemplate() : env.getTemplate();
        try {
            ParserConfiguration pCfg = parentTemplate.getParserConfiguration();
            if (pCfg.getOutputFormat() != this.outputFormat) {
                pCfg = new _ParserConfigurationWithInheritedFormat(pCfg, this.outputFormat, this.autoEscapingPolicy);
            }
            interpretedTemplate = new Template((parentTemplate.getName() != null ? parentTemplate.getName() : "nameless_template") + "->" + id, null, new StringReader(templateSource), parentTemplate.getConfiguration(), pCfg, null);
        }
        catch (IOException e) {
            throw new _MiscTemplateException((Expression)this, (Throwable)e, env, "Template parsing with \"?", this.key, "\" has failed with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failed expression:");
        }
        interpretedTemplate.setLocale(env.getLocale());
        return new TemplateProcessorModel(interpretedTemplate);
    }

    private class TemplateProcessorModel
    implements TemplateTransformModel {
        private final Template template;

        TemplateProcessorModel(Template template) {
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Writer getWriter(final Writer out, Map args) throws TemplateModelException, IOException {
            try {
                Environment env = Environment.getCurrentEnvironment();
                boolean lastFIRE = env.setFastInvalidReferenceExceptions(false);
                try {
                    env.include(this.template);
                }
                finally {
                    env.setFastInvalidReferenceExceptions(lastFIRE);
                }
            }
            catch (Exception e) {
                throw new _TemplateModelException((Throwable)e, "Template created with \"?", Interpret.this.key, "\" has stopped with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---");
            }
            return new Writer(out){

                @Override
                public void close() {
                }

                @Override
                public void flush() throws IOException {
                    out.flush();
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    out.write(cbuf, off, len);
                }
            };
        }
    }
}

