/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core;

import java.io.IOException;
import java.io.Writer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.CommonMarkupOutputFormat;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateHTMLOutputModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModelException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.utility.StringUtil;

public class HTMLOutputFormat
extends CommonMarkupOutputFormat<TemplateHTMLOutputModel> {
    public static final HTMLOutputFormat INSTANCE = new HTMLOutputFormat();

    protected HTMLOutputFormat() {
    }

    @Override
    public String getName() {
        return "HTML";
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    @Override
    public void output(String textToEsc, Writer out) throws IOException, TemplateModelException {
        StringUtil.XHTMLEnc(textToEsc, out);
    }

    @Override
    public String escapePlainText(String plainTextContent) {
        return StringUtil.XHTMLEnc(plainTextContent);
    }

    @Override
    public boolean isLegacyBuiltInBypassed(String builtInName) {
        return builtInName.equals("html") || builtInName.equals("xml") || builtInName.equals("xhtml");
    }

    @Override
    protected TemplateHTMLOutputModel newTemplateMarkupOutputModel(String plainTextContent, String markupContent) {
        return new TemplateHTMLOutputModel(plainTextContent, markupContent);
    }
}

