/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core;

import java.io.IOException;
import java.io.StringWriter;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.Assignment;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.BugException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.Environment;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.Expression;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.InvalidReferenceException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.MarkupOutputFormat;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.NonNamespaceException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.ParameterRole;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateElement;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateElements;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.SimpleScalar;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModel;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.TemplateModelException;

final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;
    private final MarkupOutputFormat<?> markupOutputFormat;

    BlockAssignment(TemplateElements children, String varName, int scope, Expression namespaceExp, MarkupOutputFormat<?> markupOutputFormat) {
        this.setChildren(children);
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.scope = scope;
        this.markupOutputFormat = markupOutputFormat;
    }

    @Override
    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        TemplateModel value;
        TemplateElement[] children = this.getChildBuffer();
        if (children != null) {
            StringWriter out = new StringWriter();
            env.visit(children, out);
            value = this.capturedStringToModel(out.toString());
        } else {
            value = this.capturedStringToModel("");
        }
        if (this.namespaceExp != null) {
            Environment.Namespace namespace;
            TemplateModel uncheckedNamespace = this.namespaceExp.eval(env);
            try {
                namespace = (Environment.Namespace)uncheckedNamespace;
            }
            catch (ClassCastException e) {
                throw new NonNamespaceException(this.namespaceExp, uncheckedNamespace, env);
            }
            if (namespace == null) {
                throw InvalidReferenceException.getInstance(this.namespaceExp, env);
            }
            namespace.put(this.varName, value);
        } else if (this.scope == 1) {
            env.setVariable(this.varName, value);
        } else if (this.scope == 3) {
            env.setGlobalVariable(this.varName, value);
        } else if (this.scope == 2) {
            env.setLocalVariable(this.varName, value);
        } else {
            throw new BugException("Unhandled scope");
        }
        return null;
    }

    private TemplateModel capturedStringToModel(String s) throws TemplateModelException {
        return this.markupOutputFormat == null ? new SimpleScalar(s) : this.markupOutputFormat.fromMarkup(s);
    }

    @Override
    protected String dump(boolean canonical) {
        StringBuilder sb = new StringBuilder();
        if (canonical) {
            sb.append("<");
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(this.varName);
        if (this.namespaceExp != null) {
            sb.append(" in ");
            sb.append(this.namespaceExp.getCanonicalForm());
        }
        if (canonical) {
            sb.append('>');
            sb.append(this.getChildrenCanonicalForm());
            sb.append("</");
            sb.append(this.getNodeTypeSymbol());
            sb.append('>');
        } else {
            sb.append(" = .nested_output");
        }
        return sb.toString();
    }

    @Override
    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    @Override
    int getParameterCount() {
        return 3;
    }

    @Override
    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.varName;
            }
            case 1: {
                return this.scope;
            }
            case 2: {
                return this.namespaceExp;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ASSIGNMENT_TARGET;
            }
            case 1: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 2: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    boolean isNestedBlockRepeater() {
        return false;
    }
}

