/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core;

import java.util.Locale;
import java.util.Map;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.AliasTargetTemplateValueFormatException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.Environment;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateFormatUtil;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateNumberFormat;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateNumberFormatFactory;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateValueFormatException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core._CoreLocaleUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.utility.StringUtil;

public final class AliasTemplateNumberFormatFactory
extends TemplateNumberFormatFactory {
    private final String defaultTargetFormatString;
    private final Map<Locale, String> localizedTargetFormatStrings;

    public AliasTemplateNumberFormatFactory(String targetFormatString) {
        this.defaultTargetFormatString = targetFormatString;
        this.localizedTargetFormatStrings = null;
    }

    public AliasTemplateNumberFormatFactory(String defaultTargetFormatString, Map<Locale, String> localizedTargetFormatStrings) {
        this.defaultTargetFormatString = defaultTargetFormatString;
        this.localizedTargetFormatStrings = localizedTargetFormatStrings;
    }

    @Override
    public TemplateNumberFormat get(String params, Locale locale, Environment env) throws TemplateValueFormatException {
        TemplateFormatUtil.checkHasNoParameters(params);
        try {
            String targetFormatString;
            if (this.localizedTargetFormatStrings != null) {
                Locale lookupLocale = locale;
                targetFormatString = this.localizedTargetFormatStrings.get(lookupLocale);
                while (targetFormatString == null && (lookupLocale = _CoreLocaleUtils.getLessSpecificLocale(lookupLocale)) != null) {
                    targetFormatString = this.localizedTargetFormatStrings.get(lookupLocale);
                }
            } else {
                targetFormatString = null;
            }
            if (targetFormatString == null) {
                targetFormatString = this.defaultTargetFormatString;
            }
            return env.getTemplateNumberFormat(targetFormatString, locale);
        }
        catch (TemplateValueFormatException e) {
            throw new AliasTargetTemplateValueFormatException("Failed to create format based on target format string,  " + StringUtil.jQuote(params) + ". Reason given: " + e.getMessage(), e);
        }
    }
}

