/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.cache;

import java.io.IOException;
import java.util.regex.Pattern;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.cache.TemplateSourceMatcher;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.utility.StringUtil;

public class PathGlobMatcher
extends TemplateSourceMatcher {
    private final String glob;
    private Pattern pattern;
    private boolean caseInsensitive;

    public PathGlobMatcher(String glob) {
        if (glob.startsWith("/")) {
            throw new IllegalArgumentException("Absolute template paths need no inital \"/\"; remove it from: " + glob);
        }
        this.glob = glob;
        this.buildPattern();
    }

    private void buildPattern() {
        this.pattern = StringUtil.globToRegularExpression(this.glob, this.caseInsensitive);
    }

    @Override
    public boolean matches(String sourceName, Object templateSource) throws IOException {
        return this.pattern.matcher(sourceName).matches();
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        boolean lastCaseInsensitive = this.caseInsensitive;
        this.caseInsensitive = caseInsensitive;
        if (lastCaseInsensitive != caseInsensitive) {
            this.buildPattern();
        }
    }

    public PathGlobMatcher caseInsensitive(boolean caseInsensitive) {
        this.setCaseInsensitive(caseInsensitive);
        return this;
    }
}

