/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.cache;

import java.io.IOException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.cache.TemplateConfigurationFactory;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.cache.TemplateConfigurationFactoryException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.cache.TemplateSourceMatcher;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.core.TemplateConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.freemarker.template.Configuration;

public class ConditionalTemplateConfigurationFactory
extends TemplateConfigurationFactory {
    private final TemplateSourceMatcher matcher;
    private final TemplateConfiguration templateConfiguration;
    private final TemplateConfigurationFactory templateConfigurationFactory;

    public ConditionalTemplateConfigurationFactory(TemplateSourceMatcher matcher, TemplateConfigurationFactory templateConfigurationFactory) {
        this.matcher = matcher;
        this.templateConfiguration = null;
        this.templateConfigurationFactory = templateConfigurationFactory;
    }

    public ConditionalTemplateConfigurationFactory(TemplateSourceMatcher matcher, TemplateConfiguration templateConfiguration) {
        this.matcher = matcher;
        this.templateConfiguration = templateConfiguration;
        this.templateConfigurationFactory = null;
    }

    @Override
    public TemplateConfiguration get(String sourceName, Object templateSource) throws IOException, TemplateConfigurationFactoryException {
        if (this.matcher.matches(sourceName, templateSource)) {
            if (this.templateConfigurationFactory != null) {
                return this.templateConfigurationFactory.get(sourceName, templateSource);
            }
            return this.templateConfiguration;
        }
        return null;
    }

    @Override
    protected void setConfigurationOfChildren(Configuration cfg) {
        if (this.templateConfiguration != null) {
            this.templateConfiguration.setParentConfiguration(cfg);
        }
        if (this.templateConfigurationFactory != null) {
            this.templateConfigurationFactory.setConfiguration(cfg);
        }
    }
}

