/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.Configuration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.InvalidConfigurationException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.MemoryConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfigurationOptions;

public abstract class FileConfiguration
extends MemoryConfiguration {
    public FileConfiguration() {
    }

    public FileConfiguration(Configuration defaults) {
        super(defaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        if (file == null) {
            throw new ConfigurationException("File must not be null");
        }
        this.createParentDirs(file);
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(data);
        }
    }

    public void save(String file) throws IOException {
        if (file == null) {
            throw new ConfigurationException("File must not be null");
        }
        this.save(new File(file));
    }

    public abstract String saveToString();

    public void load(File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        if (file == null) {
            throw new ConfigurationException("File must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        this.load(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public void load(String file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        if (file == null) {
            throw new ConfigurationException("File must not be null");
        }
        this.load(new File(file));
    }

    public abstract void loadFromString(String var1) throws InvalidConfigurationException;

    @Deprecated
    protected String buildHeader() {
        return "";
    }

    @Override
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }

    private void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }
}

