/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.DumperOptions;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.LoaderOptions;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.Yaml;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.comments.CommentEventsCollector;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.comments.CommentType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.constructor.BaseConstructor;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.emitter.Emitter;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.error.YAMLException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.events.Event;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.nodes.Node;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.representer.Representer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.org.yaml.snakeyaml.serializer.Serializer;

final class BukkitYaml
extends Yaml {
    private static final Field events = BukkitYaml.getEmitterField("events");
    private static final Field blockCommentsCollector = BukkitYaml.getEmitterField("blockCommentsCollector");
    private static final Field inlineCommentsCollector = BukkitYaml.getEmitterField("inlineCommentsCollector");

    private static Field getEmitterField(String name) {
        Field field = null;
        try {
            field = Emitter.class.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return field;
    }

    public BukkitYaml(BaseConstructor constructor, Representer representer, DumperOptions dumperOptions, LoaderOptions loadingConfig) {
        super(constructor, representer, dumperOptions, loadingConfig);
    }

    @Override
    public void serialize(Node node, Writer output) {
        Emitter emitter = new Emitter(output, this.dumperOptions);
        if (events != null && blockCommentsCollector != null && inlineCommentsCollector != null) {
            ArrayDeque<Event> newEvents = new ArrayDeque<Event>(100);
            try {
                events.set(emitter, newEvents);
                blockCommentsCollector.set(emitter, new CommentEventsCollector(newEvents, CommentType.BLANK_LINE, CommentType.BLOCK));
                inlineCommentsCollector.set(emitter, new CommentEventsCollector(newEvents, CommentType.IN_LINE));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Could not update Yaml event queue", ex);
            }
        }
        Serializer serializer = new Serializer(emitter, this.resolver, this.dumperOptions, null);
        try {
            serializer.open();
            serializer.serialize(node);
            serializer.close();
        }
        catch (IOException ex) {
            throw new YAMLException(ex);
        }
    }
}

