/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ReflectionUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigEmbeddedObject;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperties;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.IConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.transformers.ConfigEmbeddedObjectTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.transformers.ConfigObjectListTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.MemorySection;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;

public class PropertyInjector {
    public static void injectConfigurationProperties(Object bean, Map<String, FileConfiguration> configs) {
        PropertyInjector.setProperties(v -> ReflectionUtils.getConfigValue(v, configs), bean);
    }

    public static void injectEmbeddedConfigurationProperties(Object bean, Map<String, Object> configs) {
        PropertyInjector.setProperties(v -> Optional.ofNullable(configs.get(v)), bean);
    }

    public static void injectEmbeddedConfigurationProperties(Object bean, MemorySection configs) {
        PropertyInjector.setProperties(v -> Optional.ofNullable(configs.get((String)v)), bean);
    }

    public static Object getConstructorConfigurationProperty(Class<?> aClass, Class<?> classParam, Annotation[] annotations, Map<String, FileConfiguration> configs) {
        ConfigProperties configProperties = null;
        if (aClass.isAnnotationPresent(ConfigProperties.class)) {
            configProperties = aClass.getAnnotation(ConfigProperties.class);
        }
        Optional<ConfigProperty> configAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(ConfigProperty.class)).map(a2 -> (ConfigProperty)a2).findFirst();
        Optional<ConfigTransformer> configTransformerAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(ConfigTransformer.class)).map(a2 -> (ConfigTransformer)a2).findFirst();
        Optional<ConfigObjectList> configObjectListAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(ConfigObjectList.class)).map(a2 -> (ConfigObjectList)a2).findFirst();
        Optional<ConfigEmbeddedObject> configEmbeddedObject = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(ConfigEmbeddedObject.class)).map(a2 -> (ConfigEmbeddedObject)a2).findFirst();
        Optional<Object> configValue = PropertyInjector.parseConfig(classParam, configProperties, configAnnotation.get(), configTransformerAnnotation.orElse(null), configObjectListAnnotation.orElse(null), configEmbeddedObject.orElse(null), v -> ReflectionUtils.getConfigValue(v, configs));
        return configValue.orElse(null);
    }

    private static void setProperties(Function<String, Optional> configRetrievalFunction, Object o) {
        try {
            ConfigProperties configProperties = null;
            if (o.getClass().isAnnotationPresent(ConfigProperties.class)) {
                configProperties = o.getClass().getAnnotation(ConfigProperties.class);
            }
            List<Method> configMethods = ReflectionUtils.getMethodsAnnotatedWith(o.getClass(), ConfigProperty.class);
            for (Method configMethod : configMethods) {
                Optional parsedConfigValue = PropertyInjector.parseConfig(configMethod.getParameterTypes()[0], configProperties, configMethod.getAnnotation(ConfigProperty.class), null, null, null, configRetrievalFunction);
                if (!parsedConfigValue.isPresent()) continue;
                configMethod.invoke(o, parsedConfigValue.get());
            }
            for (Field f : PropertyInjector.getAllFields(new LinkedList<Field>(), o.getClass())) {
                if (!f.isAnnotationPresent(ConfigProperty.class)) continue;
                ConfigTransformer configTransformer = null;
                if (f.isAnnotationPresent(ConfigTransformer.class)) {
                    configTransformer = f.getAnnotation(ConfigTransformer.class);
                }
                ConfigObjectList configObjectListAnnotation = null;
                if (f.isAnnotationPresent(ConfigObjectList.class)) {
                    configObjectListAnnotation = f.getAnnotation(ConfigObjectList.class);
                }
                ConfigEmbeddedObject configEmbeddedObject = null;
                if (f.isAnnotationPresent(ConfigEmbeddedObject.class)) {
                    configEmbeddedObject = f.getAnnotation(ConfigEmbeddedObject.class);
                }
                ConfigProperty annotation = f.getAnnotation(ConfigProperty.class);
                Optional parsedConfigValue = PropertyInjector.parseConfig(f.getType(), configProperties, annotation, configTransformer, configObjectListAnnotation, configEmbeddedObject, configRetrievalFunction);
                if (!parsedConfigValue.isPresent()) continue;
                f.setAccessible(true);
                f.set(o, parsedConfigValue.get());
            }
        }
        catch (IllegalAccessException e) {
            throw new IocException("Cannot inject property. Make sure the field is public", e);
        }
        catch (InvocationTargetException e) {
            throw new IocException("Cannot inject property. Make sure the config property setter is public", e);
        }
    }

    private static <T> Optional<T> parseConfig(Class type, ConfigProperties configProperties, ConfigProperty configAnnotation, ConfigTransformer configTransformer, ConfigObjectList configObjectList, ConfigEmbeddedObject configEmbeddedObject, Function<String, Optional> configRetrievalFunction) {
        try {
            Class objectClass;
            String configProperty;
            Optional configValue;
            String prefix = "";
            if (configProperties != null) {
                prefix = configProperties.value() + ".";
            }
            if (!(configValue = configRetrievalFunction.apply(configProperty = prefix + configAnnotation.value())).isPresent()) {
                if (configAnnotation.required()) {
                    throw new ConfigurationException(configAnnotation.error().isEmpty() ? "Configuration not found for " + configProperty : configAnnotation.error());
                }
                return Optional.empty();
            }
            if (configEmbeddedObject != null) {
                objectClass = configEmbeddedObject.value();
                Object configSection = configValue.get();
                if (configSection instanceof MemorySection) {
                    MemorySection section = (MemorySection)configSection;
                    return Optional.ofNullable(ConfigEmbeddedObjectTransformer.transform(objectClass, section));
                }
                if (configSection instanceof LinkedHashMap) {
                    LinkedHashMap listOfMaps = (LinkedHashMap)configValue.get();
                    return Optional.ofNullable(ConfigEmbeddedObjectTransformer.transform(objectClass, listOfMaps));
                }
            }
            if (configObjectList != null) {
                objectClass = configObjectList.value();
                List listOfMaps = (List)configValue.get();
                return Optional.ofNullable(ConfigObjectListTransformer.transform(objectClass, listOfMaps));
            }
            if (configTransformer != null) {
                Object transformedConfig = configValue.get();
                for (Class<? extends IConfigTransformer> transformerClass : configTransformer.value()) {
                    IConfigTransformer iConfigTransformer;
                    Constructor<?> declaredConstructor = transformerClass.getDeclaredConstructors()[0];
                    Class<?>[] parameterTypes = declaredConstructor.getParameterTypes();
                    if (parameterTypes.length == 1) {
                        iConfigTransformer = (IConfigTransformer)declaredConstructor.newInstance(type);
                    } else if (parameterTypes.length == 0) {
                        iConfigTransformer = (IConfigTransformer)declaredConstructor.newInstance(new Object[0]);
                    } else {
                        throw new IocException("Invalid IConfigTransformer. Invalid constructor");
                    }
                    PropertyInjector.setProperties(configRetrievalFunction, iConfigTransformer);
                    transformedConfig = iConfigTransformer.mapConfig(transformedConfig);
                }
                return Optional.ofNullable(transformedConfig);
            }
            return configValue;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IocException("Cannot create configtransformer", e);
        }
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            PropertyInjector.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

