/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ReflectionUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.common.TubingConfigurationProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.AutoUpdater;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigMigrator;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationFile;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationUtil;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;

@IocBean(priority=true)
public class ConfigurationLoader {
    private List<FileConfiguration> configurations = new ArrayList<FileConfiguration>();
    private final TubingPlugin tubingPlugin;
    private List<ConfigurationFile> configurationFiles = new ArrayList<ConfigurationFile>();

    public ConfigurationLoader(@InjectTubingPlugin TubingPlugin tubingPlugin, TubingConfigurationProvider tubingConfigurationProvider) {
        this.tubingPlugin = tubingPlugin;
        this.configurationFiles = tubingConfigurationProvider.getConfigurationFiles();
        boolean success = this.loadConfig(tubingPlugin, tubingConfigurationProvider.getConfigurationMigrators());
        if (!success) {
            throw new ConfigurationException("Could not load TubingConfigurationProvider");
        }
    }

    private boolean loadConfig(TubingPlugin tubingPlugin, List<ConfigMigrator> configurationMigrators) {
        this.configurations = new ArrayList<FileConfiguration>();
        if (this.configurationFiles.isEmpty()) {
            return true;
        }
        for (ConfigurationFile configurationFile : this.configurationFiles) {
            ConfigurationUtil.saveConfigFile(tubingPlugin, configurationFile.getPath());
            FileConfiguration currentConfig = ConfigurationUtil.loadConfiguration(tubingPlugin, configurationFile.getPath());
            configurationFile.setFileConfiguration(currentConfig);
        }
        for (ConfigurationFile configurationFile : this.configurationFiles) {
            AutoUpdater.runMigrations(tubingPlugin, this.configurationFiles, configurationMigrators);
            FileConfiguration updatedConfig = AutoUpdater.updateConfig(tubingPlugin, configurationFile);
            if (updatedConfig == null) {
                return false;
            }
            configurationFile.setFileConfiguration(updatedConfig);
        }
        for (ConfigurationFile configurationFile : this.configurationFiles) {
            String newConfigFile = this.parseConfigurationPropertiesFromFile(configurationFile.getPath());
            FileConfiguration configuration = ConfigurationUtil.loadConfiguration(newConfigFile);
            configurationFile.setFileConfiguration(configuration);
            this.configurations.add(configuration);
        }
        return true;
    }

    public Map<String, FileConfiguration> getConfigurationFiles() {
        return this.configurationFiles.stream().collect(Collectors.toMap(ConfigurationFile::getIdentifier, ConfigurationFile::getFileConfiguration, (a2, b) -> a2));
    }

    public <T> Optional<T> getConfigValue(String identifier) {
        return ReflectionUtils.getConfigValue(identifier, this.getConfigurationFiles());
    }

    public Optional<String> getConfigStringValue(String identifier) {
        return ReflectionUtils.getConfigStringValue(identifier, this.getConfigurationFiles());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseConfigurationPropertiesFromFile(String configPath) {
        File dataFolder = this.tubingPlugin.getDataFolder();
        String fullConfigResourcePath = configPath.replace('\\', '/');
        File configFile = new File(dataFolder, fullConfigResourcePath);
        try {
            FileReader fr = new FileReader(configFile);
            StringBuilder totalStr = new StringBuilder();
            try (BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    totalStr.append(line).append(System.getProperty("line.separator"));
                }
                String string = this.replaceConfigProperties(totalStr.toString());
                return string;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not replace configuration properties in yaml file");
        }
    }

    private String replaceConfigProperties(String message) {
        String newMessage = message;
        String regexString = Pattern.quote("{{") + "(.*?)" + Pattern.quote("}}");
        Pattern pattern = Pattern.compile(regexString);
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String matched = matcher.group(1);
            Optional<String> configValue = this.getConfigStringValue(matched);
            if (!configValue.isPresent()) continue;
            newMessage = newMessage.replace("{{" + matched + "}}", configValue.get());
        }
        return newMessage;
    }
}

