/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ConditionalOnMissingBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.common.TubingConfigurationProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigMigrator;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationFile;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;

@IocBean
@ConditionalOnMissingBean
public class DefaultTubingConfigurationProvider
implements TubingConfigurationProvider {
    private TubingPlugin tubingPlugin;

    public DefaultTubingConfigurationProvider(@InjectTubingPlugin TubingPlugin tubingPlugin) {
        this.tubingPlugin = tubingPlugin;
    }

    @Override
    public List<ConfigMigrator> getConfigurationMigrators() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigurationFile> getConfigurationFiles() {
        InputStream defConfigStream = this.getResource(this.tubingPlugin, "config.yml");
        if (defConfigStream != null) {
            return Collections.singletonList(new ConfigurationFile("config.yml"));
        }
        return Collections.emptyList();
    }

    private InputStream getResource(TubingPlugin tubingPlugin, String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        try {
            URL url = tubingPlugin.getPluginClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException var4) {
            return null;
        }
    }
}

