/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;

public class ReflectionUtils {
    public static List<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> ... annotations) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            for (Method method : klass.getDeclaredMethods()) {
                if (!Arrays.stream(annotations).allMatch(method::isAnnotationPresent)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static <T> Optional<T> getConfigValue(String identifier, Map<String, FileConfiguration> configs) {
        identifier = ReflectionUtils.replaceNestedValues(identifier, configs);
        String configFileId = "config";
        String path = identifier;
        String[] fileSelectors = identifier.split(":", 2);
        if (fileSelectors.length == 2) {
            configFileId = fileSelectors[0];
            path = fileSelectors[1];
        }
        return Optional.ofNullable(configs.get(configFileId).get(path));
    }

    public static Optional<String> getConfigStringValue(String identifier, Map<String, FileConfiguration> configs) {
        identifier = ReflectionUtils.replaceNestedValues(identifier, configs);
        String configFileId = "config";
        String path = identifier;
        String[] fileSelectors = identifier.split(":", 2);
        if (fileSelectors.length == 2) {
            configFileId = fileSelectors[0];
            path = fileSelectors[1];
        }
        return Optional.ofNullable(configs.get(configFileId).getString(path));
    }

    private static String replaceNestedValues(String identifier, Map<String, FileConfiguration> configs) {
        String regexString = Pattern.quote("%") + "(.*?)" + Pattern.quote("%");
        Pattern pattern = Pattern.compile(regexString);
        Matcher matcher = pattern.matcher(identifier);
        while (matcher.find()) {
            String nestedConfig = matcher.group(1);
            Optional configValue = ReflectionUtils.getConfigValue(nestedConfig, configs);
            if (!configValue.isPresent()) continue;
            identifier = identifier.replace("%" + nestedConfig + "%", (CharSequence)configValue.get());
        }
        return identifier;
    }
}

