/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.AfterIocLoad;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ConditionalOnMissingBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBeanProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocConditionalPropertyFilter;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ReflectionUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.PropertyInjector;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.TubingPluginInjector;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.io.github.classgraph.ClassGraph;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.libs.io.github.classgraph.ScanResult;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.TubingBeanAnnotationRegistrator;

public class IocContainer {
    private List<Class> beanAnnotations;
    private final Map<Class, Object> beans = new HashMap<Class, Object>();
    private final IocConditionalPropertyFilter iocConditionalPropertyFilter = new IocConditionalPropertyFilter();
    private TubingPlugin tubingPlugin;
    private ConfigurationLoader configurationLoader;
    private ScanResult scanResult;

    public void init(TubingPlugin tubingPlugin) {
        try {
            this.tubingPlugin = tubingPlugin;
            String pkg = tubingPlugin.getClass().getPackage().getName();
            this.scanResult = new ClassGraph().enableAllInfo().acceptPackages(pkg).scan();
            this.beanAnnotations = new ArrayList<Class>();
            for (Class<TubingBeanAnnotationRegistrator> aClass : this.scanResult.getClassesImplementing(TubingBeanAnnotationRegistrator.class).loadClasses(TubingBeanAnnotationRegistrator.class)) {
                Constructor<?> declaredConstructor = aClass.getDeclaredConstructors()[0];
                TubingBeanAnnotationRegistrator tubingBeanAnnotationRegistrator = (TubingBeanAnnotationRegistrator)declaredConstructor.newInstance(new Object[0]);
                this.beanAnnotations.addAll(tubingBeanAnnotationRegistrator.getAnnotations());
            }
            this.loadIocBeans();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Tubing could not load the IOC container", e);
        }
    }

    public ScanResult getReflections() {
        return this.scanResult;
    }

    private void loadIocBeans() {
        try {
            List<Class<?>> configurationClasses = this.scanResult.getClassesWithAnnotation(TubingConfiguration.class).loadClasses();
            List<Method> providers = configurationClasses.stream().flatMap(c -> ReflectionUtils.getMethodsAnnotatedWith(c, IocBeanProvider.class).stream()).collect(Collectors.toList());
            List<Method> multiProviders = configurationClasses.stream().flatMap(c -> ReflectionUtils.getMethodsAnnotatedWith(c, IocMultiProvider.class).stream()).collect(Collectors.toList());
            HashSet allBeans = new HashSet();
            for (Class beanAnnotation : this.beanAnnotations) {
                allBeans.addAll(new HashSet(this.scanResult.getClassesWithAnnotation(beanAnnotation).loadClasses()));
            }
            List classesWithBeanAnnotations = allBeans.stream().sorted((o1, o2) -> {
                Annotation annotation1 = Arrays.stream(o1.getAnnotations()).filter(a2 -> this.beanAnnotations.contains(a2.annotationType())).findFirst().get();
                Annotation annotation2 = Arrays.stream(o2.getAnnotations()).filter(a2 -> this.beanAnnotations.contains(a2.annotationType())).findFirst().get();
                try {
                    boolean priority1 = (Boolean)annotation1.annotationType().getMethod("priority", new Class[0]).invoke((Object)annotation1, new Object[0]);
                    boolean priority2 = (Boolean)annotation2.annotationType().getMethod("priority", new Class[0]).invoke((Object)annotation2, new Object[0]);
                    return Boolean.compare(priority2, priority1);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Invalid bean configuration. not property found");
                }
            }).collect(Collectors.toList());
            Set providedBeans = providers.stream().map(Method::getReturnType).collect(Collectors.toCollection(LinkedHashSet::new));
            Set validBeans = Stream.concat(classesWithBeanAnnotations.stream(), providedBeans.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            this.configurationLoader = (ConfigurationLoader)this.instantiateBean(this.scanResult, ConfigurationLoader.class, validBeans, providers, multiProviders, false);
            classesWithBeanAnnotations = classesWithBeanAnnotations.stream().filter(a2 -> this.iocConditionalPropertyFilter.isValidBean(this.beanAnnotations, (Class)a2, this.getConfigurationFiles())).collect(Collectors.toList());
            validBeans = Stream.concat(classesWithBeanAnnotations.stream(), providedBeans.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            for (Class clazz : validBeans) {
                this.instantiateBean(this.scanResult, clazz, validBeans, providers, multiProviders, false);
            }
            for (Class clazz : configurationClasses) {
                List<Method> afterMethods = ReflectionUtils.getMethodsAnnotatedWith(clazz, AfterIocLoad.class);
                for (Method afterMethod : afterMethods) {
                    List<Object> params = this.buildParams(clazz, this.scanResult, validBeans, providers, multiProviders, afterMethod.getParameterTypes(), afterMethod.getParameterAnnotations());
                    afterMethod.invoke(null, params.toArray());
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IocException("Could not validate instantiate beans", e);
        }
    }

    private Object instantiateBean(ScanResult scanResult, Class<?> aClass, Set<Class<?>> validBeans, List<Method> providedBeans, List<Method> multiProviders, boolean multiProvider) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Annotation annotation;
        Class multiproviderClass;
        if (multiProvider) {
            this.beans.putIfAbsent(aClass, new ArrayList());
            Set subTypesOf = scanResult.getClassesImplementing(aClass).loadClasses().stream().filter(validBeans::contains).collect(Collectors.toSet());
            List list = (List)this.beans.get(aClass);
            for (Class subClass : subTypesOf) {
                Object bean = this.createBean(scanResult, subClass, validBeans, providedBeans, multiProviders);
                if (list.contains(bean)) continue;
                list.add(bean);
            }
            Collection<Object> beans = this.getMultiProvidedBeans(scanResult, aClass, validBeans, providedBeans, multiProviders);
            list.addAll(beans);
            return this.beans.get(aClass);
        }
        if (aClass.isAnnotationPresent(IocMultiProvider.class)) {
            Class[] multiClasses = aClass.getAnnotation(IocMultiProvider.class).value();
            Object bean = this.createBean(scanResult, aClass, validBeans, providedBeans, multiProviders);
            for (Class multiClass : multiClasses) {
                this.beans.putIfAbsent(multiClass, new ArrayList());
                List list = (List)this.beans.get(multiClass);
                if (list.contains(bean) || bean == null) continue;
                list.add(bean);
            }
            return bean;
        }
        Optional<Annotation> first = Arrays.stream(aClass.getAnnotations()).filter(a1 -> this.beanAnnotations.contains(a1.annotationType())).findFirst();
        if (first.isPresent() && (multiproviderClass = (Class)(annotation = first.get()).annotationType().getMethod("multiproviderClass", new Class[0]).invoke((Object)annotation, new Object[0])) != Object.class) {
            Object bean = this.createBean(scanResult, aClass, validBeans, providedBeans, multiProviders);
            this.beans.putIfAbsent(multiproviderClass, new ArrayList());
            List list = (List)this.beans.get(multiproviderClass);
            if (!list.contains(bean) && bean != null) {
                list.add(bean);
            }
            return bean;
        }
        if (aClass.isInterface()) {
            Optional<Object> existingBean = this.beans.keySet().stream().filter(aClass::isAssignableFrom).map(this.beans::get).findFirst();
            if (existingBean.isPresent()) {
                return existingBean.get();
            }
            List currentProviders = providedBeans.stream().filter(p -> p.getReturnType() == aClass).collect(Collectors.toList());
            if (currentProviders.size() > 1) {
                throw new IocException("Multiple bean providers found for interface " + aClass.getName() + ". This is currently not supported");
            }
            if (currentProviders.size() == 1) {
                return this.createBean(scanResult, aClass, validBeans, providedBeans, multiProviders);
            }
            Set subTypes = scanResult.getClassesImplementing(aClass).loadClasses().stream().filter(validBeans::contains).collect(Collectors.toSet());
            Set subtypeNonConditional = subTypes.stream().filter(a2 -> !a2.isAnnotationPresent(ConditionalOnMissingBean.class)).collect(Collectors.toSet());
            Set subtypesOnMissing = subTypes.stream().filter(a2 -> a2.isAnnotationPresent(ConditionalOnMissingBean.class)).collect(Collectors.toSet());
            if (subTypes.isEmpty()) {
                throw new IocException("Cannot instantiate bean with interface " + aClass.getName() + ". No classes implementing this interface");
            }
            if (subtypeNonConditional.size() > 1) {
                throw new IocException("Multiple beans found with interface " + aClass.getName() + ". At most one bean should be defined. Use @IocMultiProvider for supporting multiple beans with one interface");
            }
            if (subtypeNonConditional.isEmpty() && subtypesOnMissing.size() > 1) {
                throw new IocException("Multiple beans found with interface " + aClass.getName() + ". At most one bean should be defined. To many beans seems to be annotated with @ConditionalOnMissingBean");
            }
            Class beanToCreate = subtypeNonConditional.isEmpty() ? (Class)subtypesOnMissing.iterator().next() : (Class)subtypeNonConditional.iterator().next();
            return this.createBean(scanResult, beanToCreate, validBeans, providedBeans, multiProviders);
        }
        return this.createBean(scanResult, aClass, validBeans, providedBeans, multiProviders);
    }

    private Object createBean(ScanResult scanResult, Class<?> aClass, Set<Class<?>> validBeans, List<Method> providers, List<Method> multiProviders) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (this.beans.containsKey(aClass)) {
            return this.beans.get(aClass);
        }
        Optional<Method> beanProvider = providers.stream().filter(p -> p.getReturnType() == aClass).findFirst();
        if (beanProvider.isPresent()) {
            return this.getProvidedBean(scanResult, aClass, validBeans, providers, multiProviders);
        }
        if (Arrays.stream(aClass.getAnnotations()).noneMatch(a2 -> this.beanAnnotations.contains(a2.annotationType())) && providers.stream().map(Method::getReturnType).noneMatch(a2 -> a2 == aClass)) {
            throw new IocException("Cannot instantiate bean. No Bean annotation present. [" + aClass.getName() + "]");
        }
        if (!validBeans.contains(aClass)) {
            throw new IocException("Cannot instantiate bean. No bean found for : [" + aClass + "]");
        }
        Constructor<?>[] declaredConstructors = aClass.getDeclaredConstructors();
        if (declaredConstructors.length > 1) {
            throw new IocException("Cannot instantiate bean with type " + aClass.getName() + ". Only one constructor should be defined");
        }
        Constructor<?> declaredConstructor = aClass.getDeclaredConstructors()[0];
        List<Object> constructorParams = this.buildParams(aClass, scanResult, validBeans, providers, multiProviders, declaredConstructor.getParameterTypes(), declaredConstructor.getParameterAnnotations());
        try {
            Object bean = declaredConstructor.newInstance(constructorParams.toArray());
            PropertyInjector.injectConfigurationProperties(bean, this.getConfigurationFiles());
            TubingPluginInjector.inject(bean, this.tubingPlugin);
            this.beans.putIfAbsent(aClass, bean);
            return bean;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IocException("Cannot instantiate bean with type " + aClass.getName() + ".", e);
        }
    }

    private Map<String, FileConfiguration> getConfigurationFiles() {
        if (this.configurationLoader == null) {
            return Collections.emptyMap();
        }
        return this.configurationLoader.getConfigurationFiles();
    }

    private Object getProvidedBean(ScanResult scanResult, Class<?> aClass, Set<Class<?>> validBeans, List<Method> providers, List<Method> multiProviders) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Optional<Method> beanProvider = providers.stream().filter(p -> p.getReturnType() == aClass).findFirst();
        if (beanProvider.isPresent()) {
            List<Object> params = this.buildParams(aClass, scanResult, validBeans, providers, multiProviders, beanProvider.get().getParameterTypes(), beanProvider.get().getParameterAnnotations());
            Object invoke = beanProvider.get().invoke(null, params.toArray());
            if (invoke != null) {
                this.beans.putIfAbsent(beanProvider.get().getReturnType(), invoke);
                return invoke;
            }
        }
        return null;
    }

    private Collection<Object> getMultiProvidedBeans(ScanResult scanResult, Class<?> aClass, Set<Class<?>> validBeans, List<Method> providers, List<Method> multiProviders) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Optional<Method> beanProvider = multiProviders.stream().filter(p -> {
            Class[] multiProvidedClasses = p.getAnnotation(IocMultiProvider.class).value();
            return Arrays.asList(multiProvidedClasses).contains(aClass);
        }).findFirst();
        if (beanProvider.isPresent()) {
            List<Object> params = this.buildParams(aClass, scanResult, validBeans, providers, multiProviders, beanProvider.get().getParameterTypes(), beanProvider.get().getParameterAnnotations());
            Collection invoke = (Collection)beanProvider.get().invoke(null, params.toArray());
            multiProviders.remove(beanProvider.get());
            return invoke == null ? Collections.emptyList() : invoke;
        }
        return Collections.emptyList();
    }

    private List<Object> buildParams(Class<?> aClass, ScanResult scanResult, Set<Class<?>> validBeans, List<Method> providedBeans, List<Method> multiProviders, Class<?>[] parameterTypes, Annotation[][] parameterAnnotations) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ArrayList<Object> constructorParams = new ArrayList<Object>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> classParam = parameterTypes[i];
            Annotation[] annotations = parameterAnnotations[i];
            Optional<Annotation> multiAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(IocMulti.class)).findFirst();
            Optional<ConfigProperty> configAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(ConfigProperty.class)).map(a2 -> (ConfigProperty)a2).findFirst();
            Optional<InjectTubingPlugin> tubingPluginAnnotation = Arrays.stream(annotations).filter(a2 -> a2.annotationType().equals(InjectTubingPlugin.class)).map(a2 -> (InjectTubingPlugin)a2).findFirst();
            if (tubingPluginAnnotation.isPresent()) {
                constructorParams.add(this.tubingPlugin);
                continue;
            }
            if (configAnnotation.isPresent()) {
                Object property = PropertyInjector.getConstructorConfigurationProperty(aClass, classParam, annotations, this.getConfigurationFiles());
                constructorParams.add(property);
                continue;
            }
            if (multiAnnotation.isPresent()) {
                IocMulti iocMulti = (IocMulti)multiAnnotation.get();
                constructorParams.add(this.instantiateBean(scanResult, iocMulti.value(), validBeans, providedBeans, multiProviders, true));
                continue;
            }
            Object o = this.instantiateBean(scanResult, classParam, validBeans, providedBeans, multiProviders, false);
            constructorParams.add(o);
        }
        return constructorParams;
    }

    public void registerBean(Object o) {
        this.beans.put(o.getClass(), o);
    }

    public <T> T get(Class<T> clazz) {
        if (clazz.isInterface()) {
            List collect = this.beans.keySet().stream().filter(clazz::isAssignableFrom).map(this.beans::get).collect(Collectors.toList());
            if (collect.size() > 1) {
                throw new IocException("Cannot retrieve bean with interface " + clazz.getName() + ". Too many implementations registered. Use `getList` to retrieve a list of all beans");
            }
            if (collect.isEmpty()) {
                throw new IocException("Cannot retrieve bean with interface " + clazz.getName() + ". No implementation registered");
            }
            return collect.get(0);
        }
        return (T)this.beans.get(clazz);
    }

    public <T> List<T> getList(Class<T> clazz) {
        return (List)this.beans.get(clazz);
    }
}

