/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.be.garagepoort.mcioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocException;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.ReflectionUtils;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;

public class IocConditionalPropertyFilter {
    public boolean isValidBean(List<Class> beanAnnotations, Class clazz, Map<String, FileConfiguration> configs) {
        try {
            Annotation annotation = Arrays.stream(clazz.getAnnotations()).filter(a2 -> beanAnnotations.contains(a2.annotationType())).findFirst().orElseThrow(() -> new RuntimeException("Invalid Tubing configuration. No bean annotation on class: " + clazz.getName()));
            String conditionalOnProperty = (String)annotation.annotationType().getMethod("conditionalOnProperty", new Class[0]).invoke((Object)annotation, new Object[0]);
            if (!this.isEmpty(conditionalOnProperty)) {
                List conditionSections = Arrays.stream(conditionalOnProperty.split("&&")).map(String::trim).collect(Collectors.toList());
                return conditionSections.stream().allMatch(c -> this.isValid(configs, (String)c));
            }
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Invalid bean configuration. not property found");
        }
    }

    private boolean isValid(Map<String, FileConfiguration> configs, String conditionalOnProperty) {
        if (conditionalOnProperty.startsWith("isNotEmpty")) {
            String key = this.substringBetween(conditionalOnProperty, "(", ")");
            String configValue = ReflectionUtils.getConfigStringValue(key, configs).orElseThrow(() -> new IocException("ConditionOnProperty referencing an unknown property [" + key + "]"));
            return this.isNotEmpty(configValue);
        }
        if (conditionalOnProperty.startsWith("isEmpty")) {
            String key = this.substringBetween(conditionalOnProperty, "(", ")");
            String configValue = ReflectionUtils.getConfigStringValue(key, configs).orElseThrow(() -> new IocException("ConditionOnProperty referencing an unknown property [" + key + "]"));
            return this.isBlank(configValue);
        }
        String[] split = conditionalOnProperty.split("=", 2);
        String key = split[0];
        String value = split[1];
        String configValue = ReflectionUtils.getConfigStringValue(key, configs).orElseThrow(() -> new IocException("ConditionOnProperty referencing an unknown property [" + key + "]"));
        return configValue.equalsIgnoreCase(value);
    }

    private String substringBetween(String str, String open, String close) {
        if (str != null && open != null && close != null) {
            int end;
            int start = str.indexOf(open);
            if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
                return str.substring(start + open.length(), end);
            }
            return null;
        }
        return null;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private boolean isNotEmpty(String str) {
        return !this.isEmpty(str);
    }

    private boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

