/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.session.enhancers;

import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.application.session.SessionEnhancer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={SessionEnhancer.class})
public class PlayerSettingsSessionEnhancer
implements SessionEnhancer {
    private final PlayerSettingsRepository playerSettingsRepository;
    private final ModeProvider modeProvider;

    public PlayerSettingsSessionEnhancer(PlayerSettingsRepository playerSettingsRepository, ModeProvider modeProvider) {
        this.playerSettingsRepository = playerSettingsRepository;
        this.modeProvider = modeProvider;
    }

    @Override
    public void enhance(PlayerSession playerSession) {
        Player player = Bukkit.getPlayer((UUID)playerSession.getUuid());
        if (player != null) {
            PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
            playerSession.setInStaffMode(playerSettings.isInStaffMode());
            playerSession.setVanishType(playerSettings.getVanishType());
            if (playerSettings.isInStaffMode()) {
                Optional<GeneralModeConfiguration> configuration = this.modeProvider.getConfiguration(playerSettings.getModeName().orElse(null));
                configuration.ifPresent(playerSession::setModeConfig);
            }
        }
    }
}

