/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.session.enhancers;

import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.application.session.SessionEnhancer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;

@IocBean(conditionalOnProperty="mute-module.enabled=true")
@IocMultiProvider(value={SessionEnhancer.class})
public class MuteSessionEnhancer
implements SessionEnhancer {
    private final MuteService muteService;
    private final BukkitUtils bukkitUtils;

    public MuteSessionEnhancer(MuteService muteService, BukkitUtils bukkitUtils) {
        this.muteService = muteService;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    public void enhance(PlayerSession playerSession) {
        this.bukkitUtils.runTaskAsync(() -> this.muteService.getMuteByMutedUuid(playerSession.getUuid()).ifPresent(m -> playerSession.setMuted(true)));
    }
}

