/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.session.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.session.database.PlayerSettingsEntity;
import net.shortninja.staffplus.core.application.session.database.PlayerSettingsSqlRepository;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.QueryBuilderFactory;
import net.shortninja.staffplusplus.vanish.VanishType;

@IocBean
public class PlayerSettingsSqlRepositoryImpl
implements PlayerSettingsSqlRepository {
    private final QueryBuilderFactory query;

    public PlayerSettingsSqlRepositoryImpl(QueryBuilderFactory query) {
        this.query = query;
    }

    @Override
    public int saveSessions(PlayerSettingsEntity playerSettingsEntity) {
        return this.query.create().insertQuery("INSERT INTO sp_sessions(player_uuid, vanish_type, in_staff_mode, muted_staff_chat_channels, sound_disabled_staff_chat_channels, staff_mode_name) VALUES(?, ?, ?, ?, ?, ?);", insert -> {
            insert.setString(1, playerSettingsEntity.getPlayerUuid().toString());
            insert.setString(2, playerSettingsEntity.getVanishType().toString());
            insert.setBoolean(3, playerSettingsEntity.getStaffMode());
            insert.setString(4, String.join((CharSequence)";", playerSettingsEntity.getMutedStaffChatChannels()));
            insert.setString(5, String.join((CharSequence)";", playerSettingsEntity.getSoundDisabledStaffChatChannels()));
            if (playerSettingsEntity.getStaffModeName() == null) {
                insert.setNull(6, 12);
            } else {
                insert.setString(6, playerSettingsEntity.getStaffModeName());
            }
        });
    }

    @Override
    public void update(PlayerSettingsEntity playerSettingsEntity) {
        this.query.create().updateQuery("UPDATE sp_sessions set vanish_type=?, in_staff_mode=?, muted_staff_chat_channels=? , sound_disabled_staff_chat_channels=? , staff_mode_name=? WHERE ID=?", insert -> {
            insert.setString(1, playerSettingsEntity.getVanishType().toString());
            insert.setBoolean(2, playerSettingsEntity.getStaffMode());
            insert.setString(3, String.join((CharSequence)";", playerSettingsEntity.getMutedStaffChatChannels()));
            insert.setString(4, String.join((CharSequence)";", playerSettingsEntity.getSoundDisabledStaffChatChannels()));
            if (playerSettingsEntity.getStaffModeName() == null) {
                insert.setNull(5, 12);
            } else {
                insert.setString(5, playerSettingsEntity.getStaffModeName());
            }
            insert.setInt(6, playerSettingsEntity.getId());
        });
    }

    @Override
    public Optional<PlayerSettingsEntity> findSettings(UUID uuid) {
        return this.query.create().findOne("SELECT * FROM sp_sessions WHERE player_uuid = ?", ps -> ps.setString(1, uuid.toString()), this::buildSessionEntity);
    }

    private PlayerSettingsEntity buildSessionEntity(ResultSet rs) throws SQLException {
        int id = rs.getInt("ID");
        UUID playerUuid = UUID.fromString(rs.getString("player_uuid"));
        VanishType vanishType = VanishType.valueOf(rs.getString("vanish_type"));
        boolean inStaffMode = rs.getBoolean("in_staff_mode");
        HashSet<String> staffChatMuted = rs.getString("muted_staff_chat_channels") == null ? new HashSet<String>() : Arrays.stream(rs.getString("muted_staff_chat_channels").split(";")).collect(Collectors.toSet());
        HashSet<String> soundDisabledStaffChatChannels = rs.getString("sound_disabled_staff_chat_channels") == null ? new HashSet<String>() : Arrays.stream(rs.getString("sound_disabled_staff_chat_channels").split(";")).collect(Collectors.toSet());
        String staffModeName = rs.getString("staff_mode_name");
        return new PlayerSettingsEntity(id, playerUuid, vanishType, inStaffMode, staffChatMuted, soundDisabledStaffChatChannels, staffModeName);
    }
}

