/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.session;

import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.session.OnlinePlayerSession;
import net.shortninja.staffplus.core.common.gui.IGui;
import net.shortninja.staffplus.core.domain.chat.ChatAction;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.vanish.VanishType;

public class PlayerSession
implements OnlinePlayerSession {
    private final UUID uuid;
    private String name;
    private IGui currentGui = null;
    private ChatAction chatAction = null;
    private String activeStaffChatChannel = null;
    private boolean isFrozen = false;
    private boolean underInvestigation = false;
    private boolean isProtected = false;
    private boolean muted = false;
    private boolean isInStaffMode = false;
    private boolean canViewStyleIds = false;
    private GeneralModeConfiguration modeConfig;
    private VanishType vanishType = VanishType.NONE;

    public PlayerSession(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<IGui> getCurrentGui() {
        return Optional.ofNullable(this.currentGui);
    }

    @Override
    public void setCurrentGui(IGui currentGui) {
        this.currentGui = currentGui;
    }

    @Override
    public ChatAction getChatAction() {
        return this.chatAction;
    }

    @Override
    public void setChatAction(ChatAction chatAction) {
        this.chatAction = chatAction;
    }

    @Override
    public boolean isInStaffMode() {
        return this.isInStaffMode;
    }

    @Override
    public void setInStaffMode(boolean inStaffMode) {
        this.isInStaffMode = inStaffMode;
    }

    @Override
    public Optional<GeneralModeConfiguration> getModeConfig() {
        return Optional.ofNullable(this.modeConfig);
    }

    @Override
    public void setModeConfig(GeneralModeConfiguration modeConfig) {
        this.modeConfig = modeConfig;
    }

    @Override
    public Optional<String> getActiveStaffChatChannel() {
        return Optional.ofNullable(this.activeStaffChatChannel);
    }

    @Override
    public void setActiveStaffChatChannel(String activeStaffChatChannel) {
        this.activeStaffChatChannel = activeStaffChatChannel;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public void setProtected(boolean aProtected) {
        this.isProtected = aProtected;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public void setFrozen(boolean isFrozen) {
        this.isFrozen = isFrozen;
    }

    @Override
    public VanishType getVanishType() {
        return this.vanishType;
    }

    @Override
    public void setVanishType(VanishType vanishType) {
        this.vanishType = vanishType;
    }

    @Override
    public boolean isVanished() {
        return this.vanishType == VanishType.TOTAL || this.vanishType == VanishType.PLAYER;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    @Override
    public void setUnderInvestigation(boolean underInvestigation) {
        this.underInvestigation = underInvestigation;
    }

    @Override
    public boolean isUnderInvestigation() {
        return this.underInvestigation;
    }

    @Override
    public boolean isMuted() {
        return this.muted;
    }

    @Override
    public boolean isCanViewStyleIds() {
        return this.canViewStyleIds;
    }

    @Override
    public void setCanViewStyleIds(boolean canViewStyleIds) {
        this.canViewStyleIds = canViewStyleIds;
    }
}

