/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.application.session.OnlinePlayerSession;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.application.session.SessionLoader;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.IPlayerSession;
import net.shortninja.staffplusplus.session.SessionManager;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@IocBean
public class OnlineSessionsManager
implements SessionManager {
    @ConfigProperty(value="permissions:member")
    private String permissionMember;
    private static final Map<UUID, PlayerSession> playerSessions = new HashMap<UUID, PlayerSession>();
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;
    private final SessionLoader sessionLoader;

    public OnlineSessionsManager(PermissionHandler permissionHandler, PlayerManager playerManager, SessionLoader sessionLoader) {
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
        this.sessionLoader = sessionLoader;
        Bukkit.getOnlinePlayers().forEach(this::get);
    }

    public Collection<? extends OnlinePlayerSession> getAll() {
        return playerSessions.values();
    }

    public Collection<? extends OnlinePlayerSession> getOnlineStaffMembers() {
        ArrayList sessions = new ArrayList();
        for (OnlinePlayerSession onlinePlayerSession : this.getAll()) {
            this.playerManager.getOnlinePlayer(onlinePlayerSession.getUuid()).map(SppPlayer::getPlayer).filter(p -> this.permissionHandler.has((Player)p, this.permissionMember)).ifPresent(p -> sessions.add(s));
        }
        return sessions;
    }

    @Override
    public IPlayerSession get(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return player == null ? null : this.get(player);
    }

    @Override
    public PlayerSession get(Player player) {
        if (!this.has(player.getUniqueId())) {
            playerSessions.put(player.getUniqueId(), this.sessionLoader.loadSession(player));
        }
        return playerSessions.get(player.getUniqueId());
    }

    public boolean has(UUID uuid) {
        return playerSessions.containsKey(uuid);
    }

    public void remove(Player player) {
        playerSessions.remove(player.getUniqueId());
    }
}

