/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.queue;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.queue.QueueMessage;
import net.shortninja.staffplus.core.application.queue.QueueStatus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.QueryBuilderFactory;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;

@IocBean(conditionalOnProperty="storage.type=mysql")
public class QueueRepository {
    private final QueryBuilderFactory query;

    public QueueRepository(QueryBuilderFactory query) {
        this.query = query;
    }

    public void updateStatus(int id, QueueStatus status, String statusMessage) {
        this.query.create().updateQuery("UPDATE sp_queue set status=?, status_message=? WHERE id=?;", insert -> {
            insert.setString(1, status.name());
            insert.setString(2, statusMessage);
            insert.setInt(3, id);
        });
    }

    public Optional<QueueMessage> findNextQueueMessage(String processingGroup, ServerSyncConfig serverSyncConfig) {
        UUID processId = UUID.randomUUID();
        this.query.create().updateQuery("UPDATE sp_queue SET process_id = ? WHERE process_id IS NULL AND `type` LIKE ? " + Constants.getServerNameFilterWithAnd(serverSyncConfig) + " ORDER BY timestamp ASC LIMIT 1", ps -> {
            ps.setString(1, processId.toString());
            ps.setString(2, processingGroup + "%");
        });
        return this.query.create().findOne("SELECT * FROM sp_queue where process_id=?", ps -> ps.setString(1, processId.toString()), this::buildQueueMessage);
    }

    private QueueMessage buildQueueMessage(ResultSet rs) throws SQLException {
        return new QueueMessage(rs.getInt("ID"), QueueStatus.valueOf(rs.getString("status")), rs.getString("type"), rs.getString("data"), rs.getString("status_message"), rs.getLong("timestamp"));
    }
}

