/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.queue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.queue.QueueMessage;
import net.shortninja.staffplus.core.application.queue.QueueMessageListener;
import net.shortninja.staffplus.core.application.queue.QueueRepository;
import net.shortninja.staffplus.core.application.queue.QueueStatus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.common.bungee.GsonParser;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class QueueMessageProcessor
extends BukkitRunnable {
    private static final long TIMER = 10L;
    private final QueueRepository queueRepository;
    private final GsonParser gsonParser;
    protected final ServerSyncConfiguration serverSyncConfiguration;
    private final Map<String, QueueMessageListener> listeners = new HashMap<String, QueueMessageListener>();

    public QueueMessageProcessor(QueueRepository queueRepository, GsonParser gsonParser, @IocMulti(value=QueueMessageListener.class) List<QueueMessageListener> listeners, ServerSyncConfiguration serverSyncConfiguration) {
        this.queueRepository = queueRepository;
        this.gsonParser = gsonParser;
        this.serverSyncConfiguration = serverSyncConfiguration;
        listeners.stream().filter(t -> t.getType().startsWith(this.getProcessingGroup())).forEach(listener -> this.listeners.put(listener.getType(), (QueueMessageListener)listener));
        this.runTaskTimerAsynchronously((Plugin)StaffPlusPlus.get(), 200L, 200L);
    }

    protected abstract String getProcessingGroup();

    protected abstract ServerSyncConfig getServerSyncConfig();

    public void run() {
        Optional<QueueMessage> queueMessage = this.queueRepository.findNextQueueMessage(this.getProcessingGroup(), this.getServerSyncConfig());
        queueMessage.ifPresent(message -> {
            try {
                if (!this.listeners.containsKey(message.getType())) {
                    StaffPlusPlus.getPlugin().getLogger().warning("No QueueMessageListener for type [" + message.getType() + "]");
                }
                QueueMessageListener listener = this.listeners.get(message.getType());
                Object payload = null;
                if (listener.getMessageClass() != Void.class) {
                    payload = this.gsonParser.fromJson(message.getData(), listener.getMessageClass());
                }
                String resultMessage = listener.handleMessage(payload);
                this.queueRepository.updateStatus(message.getId(), QueueStatus.PROCESSED, resultMessage);
            }
            catch (Exception e) {
                this.queueRepository.updateStatus(message.getId(), QueueStatus.FAILED, e.getMessage());
            }
        });
    }
}

